/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.config.ConsulPropertySource;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class ConsulPropertySourceLocator
implements PropertySourceLocator {
    private ConsulClient consul;
    private ConsulConfigProperties properties;

    public ConsulPropertySourceLocator(ConsulClient consul, ConsulConfigProperties properties) {
        this.consul = consul;
        this.properties = properties;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            String appName = env.getProperty("spring.application.name");
            List<String> profiles = Arrays.asList(env.getActiveProfiles());
            String prefix = this.properties.getPrefix();
            ArrayList<String> contexts = new ArrayList<String>();
            String defaultContext = prefix + "/" + this.properties.getDefaultContext();
            contexts.add(defaultContext + "/");
            this.addProfiles(contexts, defaultContext, profiles);
            String baseContext = prefix + "/" + appName;
            contexts.add(baseContext + "/");
            this.addProfiles(contexts, baseContext, profiles);
            CompositePropertySource composite = new CompositePropertySource("consul");
            Collections.reverse(contexts);
            for (String propertySourceContext : contexts) {
                ConsulPropertySource propertySource = this.create(propertySourceContext);
                propertySource.init();
                composite.addPropertySource((PropertySource)propertySource);
            }
            return composite;
        }
        return null;
    }

    private ConsulPropertySource create(String context) {
        return new ConsulPropertySource(context, this.consul);
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile + "/");
        }
    }
}

