/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.Base64Utils;

public class ConsulPropertySource
extends EnumerablePropertySource<ConsulClient> {
    private String context;
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public ConsulPropertySource(String context, ConsulClient source) {
        super(context, (Object)source);
        this.context = context;
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
    }

    public void init() {
        Response response = ((ConsulClient)this.source).getKVValues(this.context, QueryParams.DEFAULT);
        List values = (List)response.getValue();
        if (values != null) {
            for (GetValue getValue : values) {
                String key = getValue.getKey().replace(this.context, "").replace('/', '.');
                String value = this.getDecoded(getValue.getValue());
                this.properties.put(key, value);
            }
        }
    }

    public String getDecoded(String value) {
        if (value == null) {
            return null;
        }
        return new String(Base64Utils.decodeFromString((String)value));
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[0]);
    }
}

