/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConsulAutoConfiguration;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.config.ConsulPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ConsulAutoConfiguration.class})
@EnableConfigurationProperties
@ConditionalOnProperty(name={"spring.cloud.consul.enabled"}, matchIfMissing=true)
public class ConsulConfigBootstrapConfiguration {
    @Autowired
    private ConsulClient consul;

    @Bean
    public ConsulConfigProperties consulConfigProperties() {
        return new ConsulConfigProperties();
    }

    @Bean
    public ConsulPropertySourceLocator consulPropertySourceLocator() {
        return new ConsulPropertySourceLocator(this.consul, this.consulConfigProperties());
    }
}

