/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.AbstractMessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pac4jHTTPPostDecoder
extends AbstractMessageDecoder<SAMLObject> {
    private static final Logger logger = LoggerFactory.getLogger(Pac4jHTTPPostDecoder.class);
    private ParserPool parserPool;
    private final WebContext context;

    public Pac4jHTTPPostDecoder(WebContext context) {
        this.context = context;
        if (this.context == null) {
            throw new TechnicalException("Context cannot be null");
        }
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        if (!"POST".equalsIgnoreCase(this.context.getRequestMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        String relayState = this.context.getRequestParameter("RelayState");
        logger.debug("Decoded SAML relay state of: {}", (Object)relayState);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)relayState);
        InputStream base64DecodedMessage = this.getBase64DecodedMessage();
        SAMLObject inboundMessage = (SAMLObject)this.unmarshallMessage(base64DecodedMessage);
        messageContext.setMessage((Object)inboundMessage);
        logger.debug("Decoded SAML message");
        this.populateBindingContext((MessageContext<SAMLObject>)messageContext);
        this.setMessageContext(messageContext);
    }

    protected InputStream getBase64DecodedMessage() throws MessageDecodingException {
        logger.debug("Getting Base64 encoded message from context, ignoring the given request");
        String encodedMessage = this.context.getRequestParameter("SAMLRequest");
        if (Strings.isNullOrEmpty((String)encodedMessage)) {
            encodedMessage = this.context.getRequestParameter("SAMLResponse");
        }
        if (Strings.isNullOrEmpty((String)encodedMessage)) {
            throw new MessageDecodingException("Request did not contain either a SAMLRequest or SAMLResponse parameter. Invalid request for SAML 2 HTTP POST binding.");
        }
        logger.trace("Base64 decoding SAML message:\n{}", (Object)encodedMessage);
        byte[] decodedBytes = Base64Support.decode((String)encodedMessage);
        if (decodedBytes == null) {
            throw new MessageDecodingException("Unable to Base64 decode SAML message");
        }
        try {
            logger.trace("Decoded SAML message:\n{}", (Object)new String(decodedBytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new TechnicalException((Throwable)e);
        }
        return new ByteArrayInputStream(decodedBytes);
    }

    protected void doDestroy() {
        this.parserPool = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        logger.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Parser pool cannot be null");
        }
    }

    protected void populateBindingContext(MessageContext<SAMLObject> messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(SAMLBindingSupport.isMessageSigned(messageContext));
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    protected XMLObject unmarshallMessage(InputStream messageStream) throws MessageDecodingException {
        try {
            XMLObject message = XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.getParserPool(), (InputStream)messageStream);
            return message;
        }
        catch (XMLParserException e) {
            throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)((Object)e));
        }
    }

    @Nonnull
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(@Nonnull ParserPool pool) {
        Constraint.isNotNull((Object)pool, (String)"ParserPool cannot be null");
        this.parserPool = pool;
    }
}

