/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import java.io.FileOutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.io.Resource;
import org.pac4j.core.io.WritableResource;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.storage.EmptyStorageFactory;
import org.pac4j.saml.storage.SAMLMessageStorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ClientConfiguration
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2ClientConfiguration.class);
    private KeyStore keyStore;
    private Resource keystoreResource;
    private String keystorePassword;
    private String privateKeyPassword;
    private Resource identityProviderMetadataResource;
    private String identityProviderEntityId;
    private String serviceProviderEntityId;
    private int maximumAuthenticationLifetime;
    private boolean forceAuth = false;
    private boolean forceSignRedirectBindingAuthnRequest;
    private String comparisonType = null;
    private String destinationBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String authnContextClassRef = null;
    private String nameIdPolicyFormat = null;
    private WritableResource serviceProviderMetadataResource;
    private boolean forceServiceProviderMetadataGeneration;
    private SAMLMessageStorageFactory samlMessageStorageFactory = new EmptyStorageFactory();
    private boolean authnRequestSigned = true;
    private Collection<String> blackListedSignatureSigningAlgorithms;
    private List<String> signatureAlgorithms;
    private List<String> signatureReferenceDigestMethods;
    private String signatureCanonicalizationAlgorithm;
    private boolean wantsAssertionsSigned = true;
    private String keyStoreAlias;
    private String keyStoreType;

    public SAML2ClientConfiguration() {
    }

    public SAML2ClientConfiguration(String keystorePath, String keystorePassword, String privateKeyPassword, String identityProviderMetadataPath) {
        this(null, null, null, null, keystorePath, keystorePassword, privateKeyPassword, null, identityProviderMetadataPath, null, null);
    }

    public SAML2ClientConfiguration(KeyStore keystore, String keyStoreAlias, String keyStoreType, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(keystore, keyStoreAlias, keyStoreType, null, null, null, privateKeyPassword, identityProviderMetadataResource, null, null, null);
    }

    public SAML2ClientConfiguration(Resource keystoreResource, String keyStoreAlias, String keyStoreType, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(null, keyStoreAlias, keyStoreType, keystoreResource, null, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, null);
    }

    private SAML2ClientConfiguration(KeyStore keyStore, String keyStoreAlias, String keyStoreType, Resource keystoreResource, String keystorePath, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource, String identityProviderMetadataPath, String identityProviderEntityId, String serviceProviderEntityId) {
        this.keyStore = keyStore;
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreType = keyStoreType;
        this.keystoreResource = keystoreResource;
        if (this.keystoreResource == null) {
            this.keystoreResource = CommonHelper.getResource((String)keystorePath);
        }
        this.keystorePassword = keystorePassword;
        this.privateKeyPassword = privateKeyPassword;
        if (this.keystoreResource == null || !this.keystoreResource.exists()) {
            LOGGER.warn("Provided path to keystore does not exist. Creating one at {}", (Object)keystorePath);
            this.createKeystore();
        }
        this.identityProviderMetadataResource = identityProviderMetadataResource;
        if (this.identityProviderMetadataResource == null) {
            this.identityProviderMetadataResource = CommonHelper.getResource((String)identityProviderMetadataPath);
        }
        this.identityProviderEntityId = identityProviderEntityId;
        this.serviceProviderEntityId = serviceProviderEntityId;
        CommonHelper.assertNotBlank((String)"keystorePassword", (String)this.keystorePassword);
        CommonHelper.assertNotBlank((String)"privateKeyPassword", (String)this.privateKeyPassword);
        CommonHelper.assertTrue((this.identityProviderMetadataResource != null || CommonHelper.isNotBlank((String)identityProviderMetadataPath) ? 1 : 0) != 0, (String)"Either identityProviderMetadataResource or identityProviderMetadataPath must be provided");
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        this.blackListedSignatureSigningAlgorithms = new ArrayList<String>(config.getBlacklistedAlgorithms());
        this.signatureAlgorithms = new ArrayList<String>(config.getSignatureAlgorithms());
        this.signatureReferenceDigestMethods = new ArrayList<String>(config.getSignatureReferenceDigestMethods());
        this.signatureReferenceDigestMethods.remove("http://www.w3.org/2001/04/xmlenc#sha512");
        this.signatureCanonicalizationAlgorithm = config.getSignatureCanonicalizationAlgorithm();
    }

    public void setIdentityProviderMetadataPath(String identityProviderMetadataPath) {
        this.identityProviderMetadataResource = CommonHelper.getResource((String)identityProviderMetadataPath);
    }

    public void setIdentityProviderMetadataResource(Resource identityProviderMetadataResource) {
        this.identityProviderMetadataResource = identityProviderMetadataResource;
    }

    public void setIdentityProviderEntityId(String identityProviderEntityId) {
        this.identityProviderEntityId = identityProviderEntityId;
    }

    public void setServiceProviderEntityId(String serviceProviderEntityId) {
        this.serviceProviderEntityId = serviceProviderEntityId;
    }

    public void setKeystore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeystoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public void setKeystoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeystoreResource(Resource keystoreResource) {
        this.keystoreResource = keystoreResource;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystoreResource = CommonHelper.getResource((String)keystorePath);
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public void setMaximumAuthenticationLifetime(int maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }

    public boolean isForceAuth() {
        return this.forceAuth;
    }

    public void setForceAuth(boolean forceAuth) {
        this.forceAuth = forceAuth;
    }

    public String getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(String comparisonType) {
        this.comparisonType = comparisonType;
    }

    public String getDestinationBindingType() {
        return this.destinationBindingType;
    }

    public void setDestinationBindingType(String destinationBindingType) {
        this.destinationBindingType = destinationBindingType;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public void setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    public void setServiceProviderMetadataPath(String serviceProviderMetadataPath) {
        this.serviceProviderMetadataResource = (WritableResource)CommonHelper.getResource((String)serviceProviderMetadataPath);
    }

    public void setServiceProviderMetadataResource(WritableResource serviceProviderMetadataResource) {
        this.serviceProviderMetadataResource = serviceProviderMetadataResource;
    }

    public void setForceServiceProviderMetadataGeneration(boolean forceServiceProviderMetadataGeneration) {
        this.forceServiceProviderMetadataGeneration = forceServiceProviderMetadataGeneration;
    }

    public String getIdentityProviderMetadataPath() {
        return this.identityProviderMetadataResource.getFilename();
    }

    public Resource getIdentityProviderMetadataResource() {
        return this.identityProviderMetadataResource;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    public String getKeystorePath() {
        if (this.keystoreResource != null) {
            return this.keystoreResource.getFilename();
        }
        return null;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public String getIdentityProviderEntityId() {
        return this.identityProviderEntityId;
    }

    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    public int getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    public String getServiceProviderMetadataPath() {
        if (this.serviceProviderMetadataResource != null) {
            return this.serviceProviderMetadataResource.getFilename();
        }
        return null;
    }

    public WritableResource getServiceProviderMetadataResource() {
        return this.serviceProviderMetadataResource;
    }

    public boolean isForceServiceProviderMetadataGeneration() {
        return this.forceServiceProviderMetadataGeneration;
    }

    public SAMLMessageStorageFactory getSamlMessageStorageFactory() {
        return this.samlMessageStorageFactory;
    }

    public void setSamlMessageStorageFactory(SAMLMessageStorageFactory samlMessageStorageFactory) {
        this.samlMessageStorageFactory = samlMessageStorageFactory;
    }

    public Collection<String> getBlackListedSignatureSigningAlgorithms() {
        return this.blackListedSignatureSigningAlgorithms;
    }

    public void setBlackListedSignatureSigningAlgorithms(Collection<String> blackListedSignatureSigningAlgorithms) {
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
    }

    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public List<String> getSignatureReferenceDigestMethods() {
        return this.signatureReferenceDigestMethods;
    }

    public void setSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
    }

    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalizationAlgorithm;
    }

    public void setSignatureCanonicalizationAlgorithm(String signatureCanonicalizationAlgorithm) {
        this.signatureCanonicalizationAlgorithm = signatureCanonicalizationAlgorithm;
    }

    public boolean getWantsAssertionsSigned() {
        return this.wantsAssertionsSigned;
    }

    public void setWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    public SAML2ClientConfiguration clone() {
        try {
            return (SAML2ClientConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isForceSignRedirectBindingAuthnRequest() {
        return this.forceSignRedirectBindingAuthnRequest;
    }

    public void setForceSignRedirectBindingAuthnRequest(boolean forceSignRedirectBindingAuthnRequest) {
        this.forceSignRedirectBindingAuthnRequest = forceSignRedirectBindingAuthnRequest;
    }

    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    protected void init(String clientName, WebContext context) {
    }

    private void createKeystore() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (CommonHelper.isBlank((String)this.keyStoreAlias)) {
                this.keyStoreAlias = this.getClass().getSimpleName();
                LOGGER.warn("Using keystore alias {}", (Object)this.keyStoreAlias);
            }
            if (CommonHelper.isBlank((String)this.keyStoreType)) {
                this.keyStoreType = KeyStore.getDefaultType();
                LOGGER.warn("Using keystore type {}", (Object)this.keyStoreType);
            }
            KeyStore ks = KeyStore.getInstance(this.keyStoreType);
            char[] password = this.keystorePassword.toCharArray();
            ks.load(null, password);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            KeyPair kp = kpg.genKeyPair();
            X509V3CertificateGenerator cert = new X509V3CertificateGenerator();
            cert.setSerialNumber(BigInteger.valueOf(1L));
            String dn = InetAddress.getLocalHost().getHostName();
            cert.setSubjectDN((X509Name)new X509Principal("CN=" + dn));
            cert.setIssuerDN((X509Name)new X509Principal("CN=" + dn));
            cert.setPublicKey(kp.getPublic());
            cert.setNotBefore(new Date());
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(1, 1);
            cert.setNotAfter(c.getTime());
            cert.setSignatureAlgorithm("SHA1WithRSA");
            PrivateKey signingKey = kp.getPrivate();
            X509Certificate certificate = cert.generate(signingKey, "BC");
            ks.setKeyEntry(this.keyStoreAlias, signingKey, password, new Certificate[]{certificate});
            try (FileOutputStream fos = new FileOutputStream(this.keystoreResource.getFile().getCanonicalPath());){
                ks.store(fos, password);
                fos.flush();
            }
            LOGGER.info("Created keystore {} with key alias {} ", (Object)this.keystoreResource.getFile().getCanonicalPath(), (Object)ks.aliases().nextElement());
            this.keyStore = ks;
        }
        catch (Exception e) {
            throw new SAMLException("Could not create keystore", e);
        }
    }
}

