/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.mongo.credentials.authenticator;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.AbstractUsernamePasswordAuthenticator;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.exception.AccountNotFoundException;
import org.pac4j.core.exception.BadCredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.MultipleAccountsFoundException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.mongo.profile.MongoProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoAuthenticator
extends AbstractUsernamePasswordAuthenticator {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected MongoClient mongoClient;
    protected String attributes = "";
    protected String usernameAttribute = "username";
    protected String passwordAttribute = "password";
    protected String usersDatabase = "users";
    protected String usersCollection = "users";

    public MongoAuthenticator() {
    }

    public MongoAuthenticator(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public MongoAuthenticator(MongoClient mongoClient, String attributes) {
        this.mongoClient = mongoClient;
        this.attributes = attributes;
    }

    public MongoAuthenticator(MongoClient mongoClient, String attributes, PasswordEncoder passwordEncoder) {
        this.mongoClient = mongoClient;
        this.attributes = attributes;
        this.setPasswordEncoder(passwordEncoder);
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"mongoClient", (Object)this.mongoClient);
        CommonHelper.assertNotNull((String)"usernameAttribute", (Object)this.usernameAttribute);
        CommonHelper.assertNotNull((String)"passwordAttribute", (Object)this.passwordAttribute);
        CommonHelper.assertNotNull((String)"usersDatabase", (Object)this.usersDatabase);
        CommonHelper.assertNotNull((String)"usersCollection", (Object)this.usersCollection);
        CommonHelper.assertNotNull((String)"attributes", (Object)this.attributes);
        super.internalInit(context);
    }

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws HttpAction {
        this.init(context);
        String username = credentials.getUsername();
        MongoDatabase db = this.mongoClient.getDatabase(this.usersDatabase);
        MongoCollection collection = db.getCollection(this.usersCollection);
        ArrayList<Object> users = new ArrayList<Object>();
        try (MongoCursor cursor = collection.find(Filters.eq((String)this.usernameAttribute, (Object)username)).iterator();){
            for (int i = 0; cursor.hasNext() && i <= 2; ++i) {
                users.add(cursor.next());
            }
        }
        this.logger.debug("Fonund {} users for username: {}", (Object)users.size(), (Object)username);
        if (users.isEmpty()) {
            throw new AccountNotFoundException("No account found for: " + username);
        }
        if (users.size() > 1) {
            throw new MultipleAccountsFoundException("Too many accounts found for: " + username);
        }
        Map user = (Map)users.get(0);
        String returnedPassword = (String)user.get(this.passwordAttribute);
        if (!this.getPasswordEncoder().matches(credentials.getPassword(), returnedPassword)) {
            throw new BadCredentialsException("Bad credentials for: " + username);
        }
        MongoProfile profile = this.createProfile(username, this.attributes.split(","), user);
        credentials.setUserProfile((CommonProfile)profile);
    }

    protected MongoProfile createProfile(String username, String[] attributes, Map<String, Object> result) {
        MongoProfile profile = new MongoProfile();
        profile.setId(username);
        for (String attribute : attributes) {
            profile.addAttribute(attribute, result.get(attribute));
        }
        return profile;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public String getUsersDatabase() {
        return this.usersDatabase;
    }

    public void setUsersDatabase(String usersDatabase) {
        this.usersDatabase = usersDatabase;
    }

    public String getUsersCollection() {
        return this.usersCollection;
    }

    public void setUsersCollection(String usersCollection) {
        this.usersCollection = usersCollection;
    }
}

