/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.util.CommonHelper;

public class IpExtractor
implements CredentialsExtractor<TokenCredentials> {
    private final String clientName;
    private String alternateIpHeader;

    public IpExtractor(String clientName) {
        this.clientName = clientName;
    }

    public TokenCredentials extract(WebContext context) throws HttpAction {
        String ip = this.alternateIpHeader == null ? context.getRemoteAddr() : context.getRequestHeader(this.alternateIpHeader);
        if (ip == null) {
            return null;
        }
        return new TokenCredentials(ip, this.clientName);
    }

    public String getAlternateIpHeader() {
        return this.alternateIpHeader;
    }

    public void setAlternateIpHeader(String alternateIpHeader) {
        this.alternateIpHeader = alternateIpHeader;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), (Object[])new Object[]{"clientName", this.clientName, "alternateIpHeader", this.alternateIpHeader});
    }
}

