/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator.test;

import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.authenticator.UsernamePasswordAuthenticator;
import org.pac4j.http.profile.HttpProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestUsernamePasswordAuthenticator
implements UsernamePasswordAuthenticator {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleTestUsernamePasswordAuthenticator.class);

    @Override
    public void validate(UsernamePasswordCredentials credentials) {
        if (credentials == null) {
            this.throwsException("No credential");
        }
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (CommonHelper.isBlank((String)username)) {
            this.throwsException("Username cannot be blank");
        }
        if (CommonHelper.isBlank((String)password)) {
            this.throwsException("Password cannot be blank");
        }
        if (CommonHelper.areNotEquals((String)username, (String)password)) {
            this.throwsException("Username : '" + username + "' does not match password");
        }
        HttpProfile profile = new HttpProfile();
        profile.setId(username);
        profile.addAttribute("username", username);
        credentials.setUserProfile((UserProfile)profile);
    }

    protected void throwsException(String message) {
        throw new CredentialsException(message);
    }
}

