/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LabelScanStoreProvider
extends LifecycleAdapter
implements Comparable<LabelScanStoreProvider> {
    private static final String KEY = "lucene";
    private final LabelScanStore labelScanStore;
    private final int priority;

    public LabelScanStoreProvider(LabelScanStore labelScanStore, int priority) {
        this.labelScanStore = labelScanStore;
        this.priority = priority;
    }

    public static File getStoreDirectory(File storeRootDir) {
        return new File(new File(new File(storeRootDir, "schema"), "label"), KEY);
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    @Override
    public int compareTo(LabelScanStoreProvider o) {
        return this.priority - o.priority;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.labelScanStore + ", prio:" + this.priority + "]";
    }

    public static FullStoreChangeStream fullStoreLabelUpdateStream(Supplier<IndexStoreView> lazyIndexStoreView) {
        return new FullLabelStream(lazyIndexStoreView);
    }

    private static class FullLabelStream
    implements FullStoreChangeStream,
    Visitor<NodeLabelUpdate, IOException> {
        private final Supplier<IndexStoreView> lazyIndexStoreView;
        private LabelScanWriter writer;
        private long count;

        public FullLabelStream(Supplier<IndexStoreView> lazyIndexStoreView) {
            this.lazyIndexStoreView = lazyIndexStoreView;
        }

        @Override
        public long applyTo(LabelScanWriter writer) throws IOException {
            this.writer = writer;
            IndexStoreView view = this.lazyIndexStoreView.get();
            StoreScan<IOException> scan = view.visitNodes(ArrayUtils.EMPTY_INT_ARRAY, Predicates.ALWAYS_TRUE_INT, null, this);
            scan.run();
            return this.count;
        }

        public boolean visit(NodeLabelUpdate update) throws IOException {
            this.writer.write(update);
            ++this.count;
            return false;
        }
    }

    public static interface FullStoreChangeStream {
        public long applyTo(LabelScanWriter var1) throws IOException;
    }
}

