/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;

public class RelationshipPropertyExistenceConstraintVerificationFailedKernelException
extends ConstraintVerificationFailedKernelException {
    private final RelationshipPropertyExistenceConstraint constraint;
    private final long relationshipId;

    public RelationshipPropertyExistenceConstraintVerificationFailedKernelException(RelationshipPropertyExistenceConstraint constraint, long relationshipId) {
        super(constraint);
        this.constraint = constraint;
        this.relationshipId = relationshipId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Relationship(%s) with type `%s` has no value for property `%s`", this.relationshipId, tokenNameLookup.relationshipTypeGetName(this.constraint.relationshipType()), tokenNameLookup.propertyKeyGetName(this.constraint.propertyKey()));
    }

    @Override
    public RelationshipPropertyExistenceConstraint constraint() {
        return this.constraint;
    }
}

