/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SystemOutLogging;

public class StoreMigrationTool {
    public static void main(String[] args) {
        String legacyStoreDirectory = args[0];
        new StoreMigrationTool().run(legacyStoreDirectory, new Config(), new SystemOutLogging(), StoreUpgrader.NO_MONITOR);
    }

    public void run(String legacyStoreDirectory, Config config, Logging logging, StoreUpgrader.Monitor monitor) {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        ConfigMapUpgradeConfiguration upgradeConfiguration = new ConfigMapUpgradeConfiguration(config);
        StoreUpgrader migrationProcess = new StoreUpgrader(upgradeConfiguration, (FileSystemAbstraction)fs, monitor, logging);
        LifeSupport life = new LifeSupport();
        KernelExtensions kernelExtensions = life.add(new KernelExtensions(GraphDatabaseDependencies.newDependencies().kernelExtensions(), this.kernelExtensionDependencyResolver((FileSystemAbstraction)fs, config), UnsatisfiedDependencyStrategies.ignore()));
        config = StoreFactory.configForStoreDir(config, new File(legacyStoreDirectory));
        life.start();
        SchemaIndexProvider schemaIndexProvider = kernelExtensions.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        try {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck((FileSystemAbstraction)fs));
            migrationProcess.addParticipant(new StoreMigrator(new VisibleMigrationProgressMonitor(logging.getMessagesLog(StoreMigrationTool.class), System.out), (FileSystemAbstraction)fs, upgradableDatabase, config, logging));
            migrationProcess.addParticipant(schemaIndexProvider.storeMigrationParticipant((FileSystemAbstraction)fs, upgradableDatabase));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, config);){
            long startTime = System.currentTimeMillis();
            migrationProcess.migrateIfNeeded(new File(legacyStoreDirectory), schemaIndexProvider, pageCache);
            long duration = System.currentTimeMillis() - startTime;
            logging.getMessagesLog(StoreMigrationTool.class).info(String.format("Migration completed in %d s%n", duration / 1000L));
        }
        catch (IOException e) {
            throw new StoreUpgrader.UnableToUpgradeException("Failure during upgrade", e);
        }
        finally {
            life.shutdown();
        }
    }

    private DependencyResolver kernelExtensionDependencyResolver(final FileSystemAbstraction fileSystem, final Config config) {
        return new DependencyResolver.Adapter(){

            @Override
            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (type.isInstance(fileSystem)) {
                    return type.cast(fileSystem);
                }
                if (type.isInstance(config)) {
                    return type.cast(config);
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }
}

