/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;

public class StoreExpandCursor
implements Cursor {
    private final CacheLayer store;
    private final Cursor inputCursor;
    private final NeoRegister.Node.In nodeId;
    private final Register.Object.In<int[]> relTypes;
    private final Register.Object.In<Direction> expandDirection;
    private final NeoRegister.Relationship.Out relId;
    private final NeoRegister.RelType.Out relType;
    private final Register.Object.Out<Direction> direction;
    private final NeoRegister.Node.Out startNodeId;
    private final NeoRegister.Node.Out neighborNodeId;
    private final RelationshipVisitor<RuntimeException> neighborFetcher = new RelationshipVisitor<RuntimeException>(){

        @Override
        public void visit(long relId, int type, long startNode, long endNode) throws RuntimeException {
            long origin = StoreExpandCursor.this.nodeId.read();
            if (startNode == endNode) {
                StoreExpandCursor.this.startNodeId.write(origin);
                StoreExpandCursor.this.neighborNodeId.write(origin);
                StoreExpandCursor.this.direction.write((Object)Direction.BOTH);
                StoreExpandCursor.this.relType.write(type);
            } else if (startNode == origin) {
                StoreExpandCursor.this.startNodeId.write(origin);
                StoreExpandCursor.this.neighborNodeId.write(endNode);
                StoreExpandCursor.this.direction.write((Object)Direction.OUTGOING);
                StoreExpandCursor.this.relType.write(type);
            } else {
                StoreExpandCursor.this.startNodeId.write(origin);
                StoreExpandCursor.this.neighborNodeId.write(startNode);
                StoreExpandCursor.this.direction.write((Object)Direction.INCOMING);
                StoreExpandCursor.this.relType.write(type);
            }
        }
    };
    private PrimitiveLongIterator relIterator;

    public StoreExpandCursor(CacheLayer cacheLayer, Cursor inputCursor, NeoRegister.Node.In nodeId, Register.Object.In<int[]> relTypes, Register.Object.In<Direction> expandDirection, NeoRegister.Relationship.Out relId, NeoRegister.RelType.Out relType, Register.Object.Out<Direction> direction, NeoRegister.Node.Out startNodeId, NeoRegister.Node.Out neighborNodeId) {
        this.store = cacheLayer;
        this.inputCursor = inputCursor;
        this.nodeId = nodeId;
        this.relTypes = relTypes;
        this.expandDirection = expandDirection;
        this.relId = relId;
        this.relType = relType;
        this.direction = direction;
        this.startNodeId = startNodeId;
        this.neighborNodeId = neighborNodeId;
    }

    public boolean next() {
        if (this.relIterator == null && !this.nextInputNode()) {
            return false;
        }
        if (this.relIterator.hasNext()) {
            return this.nextRelationship();
        }
        this.relIterator = null;
        return this.next();
    }

    private boolean nextRelationship() {
        long next = this.relIterator.next();
        this.relId.write(next);
        try {
            this.store.relationshipVisit(next, this.neighborFetcher);
            return true;
        }
        catch (EntityNotFoundException e) {
            return this.next();
        }
    }

    private boolean nextInputNode() {
        if (this.inputCursor.next()) {
            try {
                this.relIterator = this.store.nodeListRelationships(this.nodeId.read(), (Direction)((Object)this.expandDirection.read()), (int[])this.relTypes.read());
                return true;
            }
            catch (EntityNotFoundException e) {
                return this.nextInputNode();
            }
        }
        return false;
    }

    public void reset() {
        this.inputCursor.reset();
    }

    public void close() {
        this.inputCursor.close();
    }
}

