/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.FieldUtil;
import org.jpmml.model.visitors.FieldDependencyResolver;
import org.jpmml.model.visitors.FieldReferenceFinder;
import org.jpmml.model.visitors.FieldResolver;
import org.jpmml.model.visitors.VisitorUtil;

public class DictionaryCleaner
extends FieldResolver {
    private FieldDependencyResolver fieldDependencyResolver = null;

    @Override
    public void applyTo(Visitable visitable) {
        FieldDependencyResolver fieldDependencyResolver = new FieldDependencyResolver();
        fieldDependencyResolver.applyTo(visitable);
        this.setFieldDependencyResolver(fieldDependencyResolver);
        super.applyTo(visitable);
    }

    @Override
    public PMMLObject popParent() {
        TransformationDictionary transformationDictionary;
        PMMLObject parent = super.popParent();
        if (parent instanceof LocalTransformations) {
            LocalTransformations localTransformations = (LocalTransformations)parent;
            if (localTransformations.hasDerivedFields()) {
                Set<FieldName> activeFieldNames = this.processLocalTransformations(localTransformations);
                this.clean(localTransformations.getDerivedFields(), activeFieldNames);
            }
        } else if (parent instanceof TransformationDictionary && (transformationDictionary = (TransformationDictionary)parent).hasDerivedFields()) {
            Set<FieldName> activeFieldNames = this.processTransformationDictionary(transformationDictionary);
            this.clean(transformationDictionary.getDerivedFields(), activeFieldNames);
        }
        return parent;
    }

    private Set<FieldName> processLocalTransformations(final LocalTransformations localTransformations) {
        Model model = (Model)VisitorUtil.getParent(this);
        FieldReferenceFinder fieldReferenceFinder = new FieldReferenceFinder(){
            private Set<LocalTransformations> ignoredLocalTransformations;
            {
                this.ignoredLocalTransformations = Collections.singleton(localTransformations);
            }

            @Override
            public VisitorAction visit(LocalTransformations localTransformations2) {
                if (this.ignoredLocalTransformations.contains(localTransformations2)) {
                    return VisitorAction.SKIP;
                }
                return super.visit(localTransformations2);
            }
        };
        fieldReferenceFinder.applyTo(model);
        return this.processDerivedFields(new LinkedHashSet<DerivedField>(localTransformations.getDerivedFields()), fieldReferenceFinder.getFieldNames());
    }

    private Set<FieldName> processTransformationDictionary(TransformationDictionary transformationDictionary) {
        PMML pmml = (PMML)VisitorUtil.getParent(this);
        FieldReferenceFinder fieldReferenceFinder = new FieldReferenceFinder(){

            @Override
            public VisitorAction visit(TransformationDictionary transformationDictionary) {
                return VisitorAction.SKIP;
            }
        };
        fieldReferenceFinder.applyTo(pmml);
        return this.processDerivedFields(new LinkedHashSet<DerivedField>(transformationDictionary.getDerivedFields()), fieldReferenceFinder.getFieldNames());
    }

    private Set<FieldName> processDerivedFields(Set<DerivedField> derivedFields, Set<FieldName> activeFieldNames) {
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        Set<DerivedField> activeDerivedFields = FieldUtil.selectAll(derivedFields, activeFieldNames, true);
        while (true) {
            LinkedHashSet<Field> fields = new LinkedHashSet<Field>(activeDerivedFields);
            fieldDependencyResolver.expand(fields, activeDerivedFields);
            fields.retainAll(derivedFields);
            if (fields.isEmpty()) break;
            activeDerivedFields.addAll(fields);
        }
        return FieldUtil.nameSet(activeDerivedFields);
    }

    private void clean(List<DerivedField> derivedFields, Set<FieldName> activeFieldNames) {
        Iterator<DerivedField> it = derivedFields.iterator();
        while (it.hasNext()) {
            DerivedField derivedField = it.next();
            FieldName name = derivedField.getName();
            if (activeFieldNames.contains(name)) continue;
            it.remove();
        }
    }

    private FieldDependencyResolver getFieldDependencyResolver() {
        return this.fieldDependencyResolver;
    }

    private void setFieldDependencyResolver(FieldDependencyResolver fieldDependencyResolver) {
        this.fieldDependencyResolver = fieldDependencyResolver;
    }
}

