/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.convert;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.money.CurrencyContextBuilder;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import org.javamoney.moneta.CurrencyUnitBuilder;
import org.javamoney.moneta.ExchangeRateBuilder;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;

public class IMFRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String DATA_ID = IMFRateProvider.class.getSimpleName();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"IMF", (RateType)RateType.DEFERRED, (RateType[])new RateType[0]).set("providerDescription", (Object)"International Monetary Fond")).set("days", 1)).build();
    private static final CurrencyUnit SDR = CurrencyUnitBuilder.of("SDR", CurrencyContextBuilder.of((String)IMFRateProvider.class.getSimpleName()).build()).setDefaultFractionDigits(3).build(true);
    private Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    private Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    private static final Map<String, CurrencyUnit> CURRENCIES_BY_NAME = new HashMap<String, CurrencyUnit>();

    public IMFRateProvider() {
        super(CONTEXT);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        try {
            loader.loadData(DATA_ID);
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, "Error loading initial data from IMF provider...", e);
        }
    }

    @Override
    public void newDataLoaded(String resourceId, InputStream is) {
        try {
            this.loadRatesTSV(is);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error", e);
        }
    }

    private void loadRatesTSV(InputStream inputStream) throws IOException, ParseException {
        HashMap<CurrencyUnit, List<ExchangeRate>> newCurrencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        HashMap<CurrencyUnit, List<ExchangeRate>> newSdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        DecimalFormat f = new DecimalFormat("#0.0000000000");
        ((NumberFormat)f).setGroupingUsed(false);
        BufferedReader pr = new BufferedReader(new InputStreamReader(inputStream));
        String line = pr.readLine();
        boolean currencyToSdr = true;
        List<LocalDate> timestamps = null;
        while (Objects.nonNull(line)) {
            if (line.trim().isEmpty()) {
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("SDRs per Currency unit")) {
                currencyToSdr = false;
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("Currency units per SDR")) {
                currencyToSdr = true;
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("Currency")) {
                timestamps = this.readTimestamps(line);
                line = pr.readLine();
                continue;
            }
            String[] parts = line.split("\\t");
            CurrencyUnit currency = CURRENCIES_BY_NAME.get(parts[0]);
            if (Objects.isNull(currency)) {
                this.log.finest(() -> "Uninterpretable data from IMF data feed: " + parts[0]);
                line = pr.readLine();
                continue;
            }
            Double[] values = this.parseValues(f, parts);
            for (int i = 0; i < values.length; ++i) {
                List rates;
                ExchangeRate rate;
                LocalDate fromTS;
                if (Objects.isNull(values[i])) continue;
                LocalDate localDate = fromTS = timestamps != null ? timestamps.get(i) : null;
                if (fromTS == null) continue;
                RateType rateType = RateType.HISTORIC;
                if (fromTS.equals(LocalDate.now())) {
                    rateType = RateType.DEFERRED;
                }
                if (currencyToSdr) {
                    rate = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).set((Object)fromTS)).build()).setBase(currency).setTerm(SDR).setFactor(new DefaultNumberValue(1.0 / values[i])).build();
                    rates = newCurrencyToSdr.computeIfAbsent(currency, c -> new ArrayList(5));
                    rates.add(rate);
                    continue;
                }
                rate = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).set((Object)fromTS)).build()).setBase(SDR).setTerm(currency).setFactor(DefaultNumberValue.of(1.0 / values[i])).build();
                rates = newSdrToCurrency.computeIfAbsent(currency, c -> new ArrayList(5));
                rates.add(rate);
            }
            line = pr.readLine();
        }
        newSdrToCurrency.values().forEach(c -> Collections.sort((List)List.class.cast(c)));
        newCurrencyToSdr.values().forEach(c -> Collections.sort((List)List.class.cast(c)));
        this.sdrToCurrency = newSdrToCurrency;
        this.currencyToSdr = newCurrencyToSdr;
        this.sdrToCurrency.forEach((c, l) -> this.log.finest(() -> "SDR -> " + c.getCurrencyCode() + ": " + l));
        this.currencyToSdr.forEach((c, l) -> this.log.finest(() -> c.getCurrencyCode() + " -> SDR: " + l));
    }

    private Double[] parseValues(NumberFormat f, String[] parts) throws ParseException {
        Double[] result = new Double[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            result[i - 1] = f.parse(parts[i]).doubleValue();
        }
        return result;
    }

    private List<LocalDate> readTimestamps(String line) {
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("MMMM dd, uuuu").withLocale(Locale.ENGLISH);
        String[] parts = line.split("\\\t");
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(parts.length);
        for (int i = 1; i < parts.length; ++i) {
            dates.add(LocalDate.parse(parts[i], sdf));
        }
        return dates;
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        LocalDateTime dateTime;
        if (!this.isAvailable(conversionQuery)) {
            return null;
        }
        CurrencyUnit base = conversionQuery.getBaseCurrency();
        CurrencyUnit term = conversionQuery.getCurrency();
        LocalDate timestamp = (LocalDate)conversionQuery.get(LocalDate.class);
        if (timestamp == null && (dateTime = (LocalDateTime)conversionQuery.get(LocalDateTime.class)) != null) {
            timestamp = dateTime.toLocalDate();
        }
        ExchangeRate rate1 = this.lookupRate(this.currencyToSdr.get(base), timestamp);
        ExchangeRate rate2 = this.lookupRate(this.sdrToCurrency.get(term), timestamp);
        if (base.equals(SDR)) {
            return rate2;
        }
        if (term.equals(SDR)) {
            return rate1;
        }
        if (Objects.isNull(rate1) || Objects.isNull(rate2)) {
            return null;
        }
        ExchangeRateBuilder builder = new ExchangeRateBuilder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)RateType.HISTORIC));
        builder.setBase(base);
        builder.setTerm(term);
        builder.setFactor(IMFRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
        builder.setRateChain(rate1, rate2);
        return builder.build();
    }

    private ExchangeRate lookupRate(List<ExchangeRate> list, LocalDate localDate) {
        if (Objects.isNull(list)) {
            return null;
        }
        ExchangeRate found = null;
        for (ExchangeRate rate : list) {
            if (Objects.isNull(localDate)) {
                localDate = LocalDate.now();
            }
            if (this.isValid(rate.getContext(), localDate)) {
                return rate;
            }
            if (!Objects.isNull(found)) continue;
            found = rate;
        }
        return found;
    }

    private boolean isValid(ConversionContext conversionContext, LocalDate timestamp) {
        LocalDate validAt = (LocalDate)conversionContext.get(LocalDate.class);
        return !Objects.nonNull(validAt) && validAt.equals(timestamp);
    }

    static {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            CURRENCIES_BY_NAME.put(currency.getDisplayName(Locale.ENGLISH), Monetary.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]));
        }
        CURRENCIES_BY_NAME.put("U.K. Pound Sterling", Monetary.getCurrency((String)"GBP", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("U.S. Dollar", Monetary.getCurrency((String)"USD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Bahrain Dinar", Monetary.getCurrency((String)"BHD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Botswana Pula", Monetary.getCurrency((String)"BWP", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Czech Koruna", Monetary.getCurrency((String)"CZK", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Icelandic Krona", Monetary.getCurrency((String)"ISK", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Korean Won", Monetary.getCurrency((String)"KRW", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Rial Omani", Monetary.getCurrency((String)"OMR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Nuevo Sol", Monetary.getCurrency((String)"PEN", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Qatar Riyal", Monetary.getCurrency((String)"QAR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Saudi Arabian Riyal", Monetary.getCurrency((String)"SAR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Sri Lanka Rupee", Monetary.getCurrency((String)"LKR", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Trinidad And Tobago Dollar", Monetary.getCurrency((String)"TTD", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("U.A.E. Dirham", Monetary.getCurrency((String)"AED", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Peso Uruguayo", Monetary.getCurrency((String)"UYU", (String[])new String[0]));
        CURRENCIES_BY_NAME.put("Bolivar Fuerte", Monetary.getCurrency((String)"VEF", (String[])new String[0]));
    }
}

