/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import org.javamoney.moneta.FastMoney;
import org.javamoney.moneta.function.MonetaryFunctions;
import org.javamoney.moneta.function.MonetarySummaryStatistics;

class DefaultMonetarySummaryStatistics
implements MonetarySummaryStatistics {
    private final MonetaryAmount empty;
    protected long count;
    protected MonetaryAmount min;
    protected MonetaryAmount max;
    protected MonetaryAmount sum;
    protected MonetaryAmount average;

    DefaultMonetarySummaryStatistics(CurrencyUnit currencyUnit) {
        this.empty = FastMoney.of((Number)0, Objects.requireNonNull(currencyUnit));
        this.setSameMonetary(this.empty);
    }

    @Override
    public void accept(MonetaryAmount amount) {
        if (!this.empty.getCurrency().equals(Objects.requireNonNull(amount).getCurrency())) {
            return;
        }
        if (this.isEmpty()) {
            this.setSameMonetary(amount);
            ++this.count;
        } else {
            this.doSummary(amount);
        }
    }

    @Override
    public CurrencyUnit getCurrencyUnit() {
        return this.empty.getCurrency();
    }

    @Override
    public MonetarySummaryStatistics combine(MonetarySummaryStatistics summaryStatistics) {
        Objects.requireNonNull(summaryStatistics);
        if (!this.equals(summaryStatistics)) {
            return this;
        }
        this.min = MonetaryFunctions.min(this.min, summaryStatistics.getMin());
        this.max = MonetaryFunctions.max(this.max, summaryStatistics.getMax());
        this.sum = this.sum.add(summaryStatistics.getSum());
        this.count += summaryStatistics.getCount();
        this.average = this.sum.divide(this.count);
        return this;
    }

    private void doSummary(MonetaryAmount monetaryAmount) {
        this.min = MonetaryFunctions.min(this.min, monetaryAmount);
        this.max = MonetaryFunctions.max(this.max, monetaryAmount);
        this.sum = this.sum.add(monetaryAmount);
        this.average = this.sum.divide(++this.count);
    }

    private boolean isEmpty() {
        return this.count == 0L;
    }

    private void setSameMonetary(MonetaryAmount monetary) {
        this.min = monetary;
        this.max = monetary;
        this.sum = monetary;
        this.average = monetary;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public MonetaryAmount getMin() {
        return this.min;
    }

    @Override
    public MonetaryAmount getMax() {
        return this.max;
    }

    @Override
    public MonetaryAmount getSum() {
        return this.sum;
    }

    @Override
    public MonetaryAmount getAverage() {
        return this.average;
    }

    public boolean equals(Object obj) {
        if (DefaultMonetarySummaryStatistics.class.isInstance(obj)) {
            DefaultMonetarySummaryStatistics other = (DefaultMonetarySummaryStatistics)DefaultMonetarySummaryStatistics.class.cast(obj);
            return Objects.equals(this.empty.getCurrency(), other.empty.getCurrency());
        }
        return false;
    }

    public int hashCode() {
        return this.empty.getCurrency().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[currency: ").append(this.empty.getCurrency()).append(',');
        sb.append("count:").append(this.count).append(',');
        sb.append("min:").append(this.min).append(',');
        sb.append("max:").append(this.max).append(',');
        sb.append("sum:").append(this.sum).append(',');
        sb.append("average:").append(this.average).append(']');
        return sb.toString();
    }

    @Override
    public boolean isExchangeable() {
        return false;
    }

    @Override
    public MonetarySummaryStatistics to(CurrencyUnit unit) {
        throw new UnsupportedOperationException("the default implementation of MonetarySummaryStatistics cannot do exchange rate");
    }
}

