/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.Scroll;

public class DeleteByQueryRequest
extends ActionRequest<DeleteByQueryRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)false, (boolean)true, (boolean)false);
    private String[] types = Strings.EMPTY_ARRAY;
    private BytesReference source;
    private String routing;
    private int size = 0;
    private Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)10L));
    private TimeValue timeout;

    public DeleteByQueryRequest() {
    }

    public DeleteByQueryRequest(String ... indices) {
        this.indices = indices;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.source == null) {
            validationException = ValidateActions.addValidationError((String)"source is missing", validationException);
        }
        return validationException;
    }

    public String[] indices() {
        return this.indices;
    }

    public DeleteByQueryRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public DeleteByQueryRequest indicesOptions(IndicesOptions indicesOptions) {
        if (indicesOptions == null) {
            throw new IllegalArgumentException("IndicesOptions must not be null");
        }
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public DeleteByQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public DeleteByQueryRequest source(QuerySourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public DeleteByQueryRequest source(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)Requests.CONTENT_TYPE);
            builder.map(querySource);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + querySource + "]", (Throwable)e);
        }
    }

    public DeleteByQueryRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        return this;
    }

    public DeleteByQueryRequest source(String querySource) {
        this.source = new BytesArray(querySource);
        return this;
    }

    public DeleteByQueryRequest source(byte[] querySource) {
        return this.source(querySource, 0, querySource.length);
    }

    public DeleteByQueryRequest source(byte[] querySource, int offset, int length) {
        return this.source((BytesReference)new BytesArray(querySource, offset, length));
    }

    public DeleteByQueryRequest source(BytesReference querySource) {
        this.source = querySource;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public DeleteByQueryRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public DeleteByQueryRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString((Object[])routings);
        return this;
    }

    public DeleteByQueryRequest size(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size must be greater than zero");
        }
        this.size = size;
        return this;
    }

    public int size() {
        return this.size;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public DeleteByQueryRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public DeleteByQueryRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public DeleteByQueryRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue((String)keepAlive, null, (String)(((Object)((Object)this)).getClass().getSimpleName() + ".keepAlive"))));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public DeleteByQueryRequest timeout(TimeValue timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("timeout must not be null");
        }
        this.timeout = timeout;
        return this;
    }

    public DeleteByQueryRequest timeout(String timeout) {
        this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(((Object)((Object)this)).getClass().getSimpleName() + ".timeout")));
        return this;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        this.types = in.readStringArray();
        this.source = in.readBytesReference();
        this.routing = in.readOptionalString();
        this.size = in.readVInt();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll((StreamInput)in);
        }
        if (in.readBoolean()) {
            this.timeout = TimeValue.readTimeValue((StreamInput)in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeStringArray(this.types);
        out.writeBytesReference(this.source);
        out.writeOptionalString(this.routing);
        out.writeVInt(this.size);
        out.writeOptionalStreamable((Streamable)this.scroll);
        out.writeOptionalStreamable((Streamable)this.timeout);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson((BytesReference)this.source, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "delete-by-query [" + Arrays.toString(this.indices) + "][" + Arrays.toString(this.types) + "], source[" + sSource + "]";
    }
}

