/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import org.sonar.api.BatchComponent;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.core.resource.ResourceDao;
import org.sonar.core.resource.ResourceDto;

public class ProjectInitializer
implements BatchComponent {
    private ResourceDao resourceDao;
    private Languages languages;

    public ProjectInitializer(ResourceDao resourceDao, Languages languages) {
        this.resourceDao = resourceDao;
        this.languages = languages;
    }

    public void execute(Project project) {
        this.initLanguage(project);
    }

    private void initLanguage(Project project) {
        Language language = this.languages.get(project.getLanguageKey());
        if (language == null) {
            throw new SonarException("Language with key '" + project.getLanguageKey() + "' not found");
        }
        project.setLanguage(language);
        if (project.getId() != null) {
            ResourceDto dto = this.resourceDao.getResource((long)project.getId().intValue());
            dto.setLanguage(project.getLanguageKey());
            this.resourceDao.insertOrUpdate(new ResourceDto[]{dto});
        }
    }
}

