/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONValue;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.batch.bootstrap.BootstrapSettings;
import org.sonar.batch.bootstrap.GlobalBatchProperties;
import org.sonar.batch.bootstrap.ServerClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchSettings
extends Settings {
    private Configuration deprecatedConfiguration;
    private Map<String, Map<String, String>> moduleProperties = Maps.newHashMap();

    public BatchSettings(BootstrapSettings bootstrapSettings, PropertyDefinitions propertyDefinitions, ServerClient client, Configuration deprecatedConfiguration, GlobalBatchProperties globalProperties) {
        this(bootstrapSettings, propertyDefinitions, null, client, deprecatedConfiguration, globalProperties);
    }

    public BatchSettings(BootstrapSettings bootstrapSettings, PropertyDefinitions propertyDefinitions, @Nullable ProjectReactor reactor, ServerClient client, Configuration deprecatedConfiguration, GlobalBatchProperties globalProperties) {
        super(propertyDefinitions);
        this.deprecatedConfiguration = deprecatedConfiguration;
        this.init(bootstrapSettings, reactor, client, globalProperties);
    }

    @VisibleForTesting
    public BatchSettings() {
    }

    private void init(BootstrapSettings bootstrapSettings, @Nullable ProjectReactor reactor, ServerClient client, GlobalBatchProperties globalProperties) {
        LoggerFactory.getLogger(BatchSettings.class).info("Load batch settings");
        if (reactor != null) {
            String branch = bootstrapSettings.getProperty("sonar.branch");
            String projectKey = reactor.getRoot().getKey();
            if (StringUtils.isNotBlank((String)branch)) {
                projectKey = String.format("%s:%s", projectKey, branch);
            }
            this.downloadSettings(client, projectKey);
        } else {
            this.downloadSettings(client, null);
        }
        this.addProperties(globalProperties.getProperties());
        if (reactor != null) {
            this.addProperties(reactor.getRoot().getProperties());
        }
        this.addEnvironmentVariables();
        this.addSystemProperties();
    }

    private void downloadSettings(ServerClient client, String projectKey) {
        String url = StringUtils.isNotBlank((String)projectKey) ? "/batch_bootstrap/properties?project=" + projectKey : "/batch_bootstrap/properties";
        String jsonText = client.request(url);
        List json = (List)JSONValue.parse((String)jsonText);
        for (Map jsonProperty : json) {
            String key = (String)jsonProperty.get("k");
            String value = (String)jsonProperty.get("v");
            String moduleKey = (String)jsonProperty.get("p");
            if (moduleKey == null || projectKey.equals(moduleKey)) {
                this.setProperty(key, value);
            }
            if (moduleKey == null) continue;
            HashMap map = this.moduleProperties.get(moduleKey);
            if (map == null) {
                map = Maps.newHashMap();
                this.moduleProperties.put(moduleKey, map);
            }
            map.put(key, value);
        }
    }

    public Map<String, String> getModuleProperties(String projectKey) {
        return this.moduleProperties.get(projectKey);
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedConfiguration.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedConfiguration.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedConfiguration.clear();
    }
}

