/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import com.typesafe.netty.HandlerSubscriber;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyReactiveStreamsBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyReactiveStreamsBody.class);
    private static final String NAME_IN_CHANNEL_PIPELINE = "request-body-streamer";
    private final Publisher<ByteBuffer> publisher;
    private final long contentLength;

    public NettyReactiveStreamsBody(Publisher<ByteBuffer> publisher, long contentLength) {
        this.publisher = publisher;
        this.contentLength = contentLength;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        if (future.isStreamWasAlreadyConsumed()) {
            LOGGER.warn("Stream has already been consumed and cannot be reset");
        } else {
            future.setStreamWasAlreadyConsumed(true);
            NettySubscriber subscriber = new NettySubscriber(channel, future);
            channel.pipeline().addLast(NAME_IN_CHANNEL_PIPELINE, (ChannelHandler)subscriber);
            this.publisher.subscribe((Subscriber)new SubscriberAdapter((Subscriber<HttpContent>)subscriber));
        }
    }

    private static class NettySubscriber
    extends HandlerSubscriber<HttpContent> {
        private static final Logger LOGGER = LoggerFactory.getLogger(NettySubscriber.class);
        private final Channel channel;
        private final NettyResponseFuture<?> future;

        public NettySubscriber(Channel channel, NettyResponseFuture<?> future) {
            super((EventExecutor)channel.eventLoop());
            this.channel = channel;
            this.future = future;
        }

        protected void complete() {
            EventLoop executor = this.channel.eventLoop();
            executor.execute(() -> this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener(future -> this.removeFromPipeline()));
        }

        protected void error(Throwable error) {
            if (error == null) {
                throw null;
            }
            this.removeFromPipeline();
            this.future.abort(error);
        }

        private void removeFromPipeline() {
            try {
                this.channel.pipeline().remove((ChannelHandler)this);
                LOGGER.debug(String.format("Removed handler %s from pipeline.", NettyReactiveStreamsBody.NAME_IN_CHANNEL_PIPELINE));
            }
            catch (NoSuchElementException e) {
                LOGGER.debug(String.format("Failed to remove handler %s from pipeline.", NettyReactiveStreamsBody.NAME_IN_CHANNEL_PIPELINE), (Throwable)e);
            }
        }
    }

    private static class SubscriberAdapter
    implements Subscriber<ByteBuffer> {
        private volatile Subscriber<HttpContent> subscriber;

        public SubscriberAdapter(Subscriber<HttpContent> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        public void onNext(ByteBuffer t) {
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])t.array());
            DefaultHttpContent content = new DefaultHttpContent(buffer);
            this.subscriber.onNext((Object)content);
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

