/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.channel.Channel;
import java.nio.channels.ClosedChannelException;
import org.asynchttpclient.handler.ProgressAsyncHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.future.StackTraceInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteListener.class);
    protected final NettyResponseFuture<?> future;
    protected final ProgressAsyncHandler<?> progressAsyncHandler;
    protected final boolean notifyHeaders;

    public WriteListener(NettyResponseFuture<?> future, boolean notifyHeaders) {
        this.future = future;
        this.progressAsyncHandler = future.getAsyncHandler() instanceof ProgressAsyncHandler ? (ProgressAsyncHandler)future.getAsyncHandler() : null;
        this.notifyHeaders = notifyHeaders;
    }

    private boolean abortOnThrowable(Channel channel, Throwable cause) {
        if (cause != null && this.future.getChannelState() != ChannelState.NEW) {
            if (cause instanceof IllegalStateException || cause instanceof ClosedChannelException || StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                LOGGER.debug(cause.getMessage(), cause);
                Channels.silentlyCloseChannel(channel);
            } else {
                this.future.abort(cause);
            }
            return true;
        }
        return false;
    }

    protected void operationComplete(Channel channel, Throwable cause) {
        this.future.touch();
        if (this.abortOnThrowable(channel, cause)) {
            return;
        }
        if (this.progressAsyncHandler != null) {
            boolean startPublishing;
            boolean bl = startPublishing = !this.future.getInAuth().get() && !this.future.getInProxyAuth().get();
            if (startPublishing) {
                if (this.notifyHeaders) {
                    this.progressAsyncHandler.onHeadersWritten();
                } else {
                    this.progressAsyncHandler.onContentWritten();
                }
            }
        }
    }
}

