/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.naming.OperationNotSupportedException;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.CasDefaultFlowUrlHandler;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.DefaultWebflowConfigurer;
import org.apereo.cas.web.flow.LogoutConversionService;
import org.apereo.spring.webflow.plugin.ClientFlowExecutionRepository;
import org.apereo.spring.webflow.plugin.EncryptedTranscoder;
import org.apereo.spring.webflow.plugin.Transcoder;
import org.cryptacular.bean.CipherBean;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.webflow.config.FlowBuilderServicesBuilder;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.config.FlowExecutorBuilder;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SerializedFlowExecutionSnapshotFactory;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser;
import org.springframework.webflow.mvc.builder.MvcViewFactoryCreator;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;
import org.springframework.webflow.mvc.servlet.FlowHandlerMapping;

@Configuration(value="casWebflowContextConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasWebflowContextConfiguration {
    private static final int LOGOUT_FLOW_HANDLER_ORDER = 3;
    private static final String BASE_CLASSPATH_WEBFLOW = "classpath*:/webflow";
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="registeredServiceViewResolver")
    private ViewResolver registeredServiceViewResolver;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="webflowCipherExecutor")
    private CipherExecutor webflowCipherExecutor;
    @Autowired
    @Qualifier(value="authenticationThrottle")
    private HandlerInterceptor authenticationThrottle;

    @Bean
    public ExpressionParser expressionParser() {
        WebFlowSpringELExpressionParser parser = new WebFlowSpringELExpressionParser(new SpelExpressionParser(), this.logoutConversionService());
        return parser;
    }

    @Bean
    public ConversionService logoutConversionService() {
        return new LogoutConversionService();
    }

    @RefreshScope
    @Bean
    public ViewFactoryCreator viewFactoryCreator() {
        MvcViewFactoryCreator resolver = new MvcViewFactoryCreator();
        resolver.setViewResolvers((List)ImmutableList.of((Object)this.registeredServiceViewResolver));
        return resolver;
    }

    @Bean
    public FlowUrlHandler loginFlowUrlHandler() {
        return new CasDefaultFlowUrlHandler();
    }

    @Bean
    public FlowUrlHandler logoutFlowUrlHandler() {
        CasDefaultFlowUrlHandler handler = new CasDefaultFlowUrlHandler();
        handler.setFlowExecutionKeyParameter("RelayState");
        return handler;
    }

    @RefreshScope
    @Bean
    public HandlerAdapter logoutHandlerAdapter() {
        FlowHandlerAdapter handler = new FlowHandlerAdapter(){

            public boolean supports(Object handler) {
                return super.supports(handler) && ((FlowHandler)handler).getFlowId().equals("logout");
            }
        };
        handler.setFlowExecutor(this.logoutFlowExecutor());
        handler.setFlowUrlHandler(this.logoutFlowUrlHandler());
        return handler;
    }

    @RefreshScope
    @Bean
    public CipherBean loginFlowCipherBean() {
        try {
            return new CipherBean(){

                public byte[] encrypt(byte[] bytes) {
                    return (byte[])CasWebflowContextConfiguration.this.webflowCipherExecutor.encode((Object)bytes);
                }

                public void encrypt(InputStream inputStream, OutputStream outputStream) {
                    throw new RuntimeException(new OperationNotSupportedException("Encrypting input stream is not supported"));
                }

                public byte[] decrypt(byte[] bytes) {
                    return (byte[])CasWebflowContextConfiguration.this.webflowCipherExecutor.decode((Object)bytes);
                }

                public void decrypt(InputStream inputStream, OutputStream outputStream) {
                    throw new RuntimeException(new OperationNotSupportedException("Decrypting input stream is not supported"));
                }
            };
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @RefreshScope
    @Bean
    public FlowBuilderServices builder() {
        FlowBuilderServicesBuilder builder = new FlowBuilderServicesBuilder(this.applicationContext);
        builder.setViewFactoryCreator(this.viewFactoryCreator());
        builder.setExpressionParser(this.expressionParser());
        builder.setDevelopmentMode(this.casProperties.getWebflow().isRefresh());
        return builder.build();
    }

    @Bean
    public Transcoder loginFlowStateTranscoder() {
        try {
            return new EncryptedTranscoder(this.loginFlowCipherBean());
        }
        catch (Exception e) {
            throw new BeanCreationException(e.getMessage(), (Throwable)e);
        }
    }

    @Bean
    public HandlerAdapter loginHandlerAdapter() {
        FlowHandlerAdapter handler = new FlowHandlerAdapter(){

            public boolean supports(Object handler) {
                return super.supports(handler) && ((FlowHandler)handler).getFlowId().equals("login");
            }
        };
        handler.setFlowExecutor(this.loginFlowExecutor());
        handler.setFlowUrlHandler(this.loginFlowUrlHandler());
        return handler;
    }

    @RefreshScope
    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor bean = new LocaleChangeInterceptor();
        bean.setParamName(this.casProperties.getLocale().getParamName());
        return bean;
    }

    @Bean
    public HandlerMapping logoutFlowHandlerMapping() {
        FlowHandlerMapping handler = new FlowHandlerMapping();
        handler.setOrder(3);
        handler.setFlowRegistry(this.logoutFlowRegistry());
        Object[] interceptors = new Object[]{this.localeChangeInterceptor()};
        handler.setInterceptors(interceptors);
        return handler;
    }

    @Bean
    public HandlerMapping loginFlowHandlerMapping() {
        FlowHandlerMapping handler = new FlowHandlerMapping();
        handler.setOrder(2);
        handler.setFlowRegistry(this.loginFlowRegistry());
        Object[] interceptors = new Object[]{this.localeChangeInterceptor(), this.authenticationThrottle};
        handler.setInterceptors(interceptors);
        return handler;
    }

    @RefreshScope
    @Bean
    public FlowExecutor logoutFlowExecutor() {
        FlowExecutorBuilder builder = new FlowExecutorBuilder((FlowDefinitionLocator)this.logoutFlowRegistry(), this.applicationContext);
        builder.setAlwaysRedirectOnPause(this.casProperties.getWebflow().isAlwaysPauseRedirect());
        builder.setRedirectInSameState(this.casProperties.getWebflow().isRedirectSameState());
        return builder.build();
    }

    @Bean
    public FlowDefinitionRegistry logoutFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.builder());
        builder.setBasePath(BASE_CLASSPATH_WEBFLOW);
        builder.addFlowLocationPattern("/logout/*-webflow.xml");
        return builder.build();
    }

    @Bean
    public FlowDefinitionRegistry loginFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.builder());
        builder.setBasePath(BASE_CLASSPATH_WEBFLOW);
        builder.addFlowLocationPattern("/login/*-webflow.xml");
        return builder.build();
    }

    @RefreshScope
    @Bean
    public FlowExecutor loginFlowExecutor() {
        FlowDefinitionRegistry loginFlowRegistry = this.loginFlowRegistry();
        if (this.casProperties.getWebflow().getSession().isStorage()) {
            SessionBindingConversationManager conversationManager = new SessionBindingConversationManager();
            conversationManager.setLockTimeoutSeconds(this.casProperties.getWebflow().getSession().getLockTimeout());
            conversationManager.setMaxConversations(this.casProperties.getWebflow().getSession().getMaxConversations());
            FlowExecutionImplFactory executionFactory = new FlowExecutionImplFactory();
            SerializedFlowExecutionSnapshotFactory flowExecutionSnapshotFactory = new SerializedFlowExecutionSnapshotFactory((FlowExecutionFactory)executionFactory, (FlowDefinitionLocator)this.loginFlowRegistry());
            flowExecutionSnapshotFactory.setCompress(this.casProperties.getWebflow().getSession().isCompress());
            DefaultFlowExecutionRepository repository = new DefaultFlowExecutionRepository((ConversationManager)conversationManager, (FlowExecutionSnapshotFactory)flowExecutionSnapshotFactory);
            executionFactory.setExecutionKeyFactory((FlowExecutionKeyFactory)repository);
            return new FlowExecutorImpl((FlowDefinitionLocator)loginFlowRegistry, (FlowExecutionFactory)executionFactory, (FlowExecutionRepository)repository);
        }
        ClientFlowExecutionRepository repository = new ClientFlowExecutionRepository();
        repository.setFlowDefinitionLocator((FlowDefinitionLocator)loginFlowRegistry);
        repository.setTranscoder(this.loginFlowStateTranscoder());
        FlowExecutionImplFactory factory = new FlowExecutionImplFactory();
        factory.setExecutionKeyFactory((FlowExecutionKeyFactory)repository);
        repository.setFlowExecutionFactory((FlowExecutionFactory)factory);
        return new FlowExecutorImpl((FlowDefinitionLocator)loginFlowRegistry, (FlowExecutionFactory)factory, (FlowExecutionRepository)repository);
    }

    @ConditionalOnMissingBean(name={"defaultWebflowConfigurer"})
    @Bean
    public CasWebflowConfigurer defaultWebflowConfigurer() {
        DefaultWebflowConfigurer c = new DefaultWebflowConfigurer();
        c.setLoginFlowDefinitionRegistry(this.loginFlowRegistry());
        c.setLogoutFlowDefinitionRegistry(this.logoutFlowRegistry());
        c.setFlowBuilderServices(this.builder());
        return c;
    }
}

