/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.AsciiArtUtils;
import org.apereo.cas.util.ResourceUtils;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.client.direct.DirectCasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.IsAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.authorization.generator.SpringSecurityPropertiesAuthorizationGenerator;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.http.client.direct.IpClient;
import org.pac4j.http.credentials.authenticator.IpRegexpAuthenticator;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMappingCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.WebContentInterceptor;
import org.springframework.web.servlet.view.RedirectView;

@Configuration(value="casSecurityContextConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasSecurityContextConfiguration
extends WebMvcConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSecurityContextConfiguration.class);
    private static final String CAS_CLIENT_NAME = "CasClient";
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="acceptUsersAuthenticationHandler")
    private AuthenticationHandler acceptUsersAuthenticationHandler;

    @Bean
    public WebContentInterceptor webContentInterceptor() {
        WebContentInterceptor interceptor = new WebContentInterceptor();
        interceptor.setCacheSeconds(0);
        interceptor.setAlwaysUseFullPath(true);
        return interceptor;
    }

    @RefreshScope
    @Bean
    public SecurityInterceptor requiresAuthenticationStatusInterceptor() {
        return new SecurityInterceptor(new Config((Client)new IpClient((Authenticator)new IpRegexpAuthenticator(this.casProperties.getAdminPagesSecurity().getIp()))), "IpClient");
    }

    @RefreshScope
    @Bean
    public Config config() {
        try {
            if (StringUtils.isNotBlank((String)this.casProperties.getAdminPagesSecurity().getLoginUrl()) && StringUtils.isNotBlank((String)this.casProperties.getAdminPagesSecurity().getService())) {
                CasConfiguration casConfig = new CasConfiguration(this.casProperties.getAdminPagesSecurity().getLoginUrl());
                DirectCasClient client = new DirectCasClient(casConfig);
                client.setName(CAS_CLIENT_NAME);
                Config cfg = new Config(this.casProperties.getAdminPagesSecurity().getService(), (Client)client);
                if (this.casProperties.getAdminPagesSecurity().getUsers() == null) {
                    LOGGER.warn("List of authorized users for admin pages security is not defined. Allowing access for all authenticated users");
                    client.setAuthorizationGenerator((AuthorizationGenerator)new DefaultCasAuthorizationGenerator());
                    cfg.setAuthorizer((Authorizer)new IsAuthenticatedAuthorizer());
                } else {
                    Resource file = ResourceUtils.prepareClasspathResourceIfNeeded((Resource)this.casProperties.getAdminPagesSecurity().getUsers());
                    if (file != null && file.exists()) {
                        Properties properties = new Properties();
                        properties.load(file.getInputStream());
                        client.setAuthorizationGenerator((AuthorizationGenerator)new SpringSecurityPropertiesAuthorizationGenerator(properties));
                        cfg.setAuthorizer((Authorizer)new RequireAnyRoleAuthorizer(org.springframework.util.StringUtils.commaDelimitedListToSet((String)this.casProperties.getAdminPagesSecurity().getAdminRoles())));
                    }
                }
                return cfg;
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return new Config();
    }

    @RefreshScope
    @Bean
    public SecurityInterceptor requiresAuthenticationStatusAdminEndpointsInterceptor() {
        Config cfg = this.config();
        if (cfg.getClients() == null) {
            return this.requiresAuthenticationStatusInterceptor();
        }
        CasAdminPagesSecurityInterceptor interceptor = new CasAdminPagesSecurityInterceptor(cfg, CAS_CLIENT_NAME, "securityHeaders,csrfToken,".concat(this.getAuthorizerName()));
        return interceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.statusInterceptor()).addPathPatterns(new String[]{"/status/**"});
        registry.addInterceptor((HandlerInterceptor)this.webContentInterceptor()).addPathPatterns(new String[]{"/*"});
    }

    @Bean
    public HandlerInterceptorAdapter statusInterceptor() {
        return new CasAdminStatusInterceptor();
    }

    @RefreshScope
    @Bean
    public EndpointHandlerMappingCustomizer mappingCustomizer() {
        return mapping -> mapping.setInterceptors(new Object[]{this.statusInterceptor()});
    }

    private String getAuthorizerName() {
        if (this.casProperties.getAdminPagesSecurity().getUsers() == null) {
            return IsAuthenticatedAuthorizer.class.getSimpleName();
        }
        return RequireAnyRoleAuthorizer.class.getSimpleName();
    }

    @PostConstruct
    public void init() {
        if (StringUtils.isNotBlank((String)this.casProperties.getAuthn().getAccept().getUsers())) {
            String header = "\nCAS is configured to accept a static list of credentials for authentication.\nWhile this is generally useful for demo purposes, it is STRONGLY recommended\nthat you DISABLE this authentication method (by SETTING 'cas.authn.accept.users'\nto a blank value) and switch to a mode that is more suitable for production. \n";
            AsciiArtUtils.printAsciiArt((Logger)LOGGER, (String)"STOP!", (String)"\nCAS is configured to accept a static list of credentials for authentication.\nWhile this is generally useful for demo purposes, it is STRONGLY recommended\nthat you DISABLE this authentication method (by SETTING 'cas.authn.accept.users'\nto a blank value) and switch to a mode that is more suitable for production. \n");
            this.authenticationHandlersResolvers.put(this.acceptUsersAuthenticationHandler, this.personDirectoryPrincipalResolver);
        }
    }

    public static class CasAdminPagesSecurityInterceptor
    extends SecurityInterceptor {
        public CasAdminPagesSecurityInterceptor(Config config, String clients, String authorizers) {
            super(config, clients, authorizers);
            DefaultSecurityLogic secLogic = new DefaultSecurityLogic(){

                protected HttpAction unauthorized(WebContext context, List currentClients) {
                    return HttpAction.forbidden((String)"Access Denied", (WebContext)context);
                }

                protected boolean loadProfilesFromSession(WebContext context, List currentClients) {
                    return true;
                }
            };
            secLogic.setSaveProfileInSession(true);
            this.setSecurityLogic((SecurityLogic)secLogic);
        }
    }

    public class CasAdminStatusInterceptor
    extends HandlerInterceptorAdapter {
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            String requestPath = request.getRequestURI();
            Pattern pattern = Pattern.compile("/status(/)*$");
            if (pattern.matcher(requestPath).find()) {
                return CasSecurityContextConfiguration.this.requiresAuthenticationStatusInterceptor().preHandle(request, response, handler);
            }
            return CasSecurityContextConfiguration.this.requiresAuthenticationStatusAdminEndpointsInterceptor().preHandle(request, response, handler);
        }

        public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
            if (StringUtils.isNotBlank((String)request.getQueryString()) && request.getQueryString().contains("ticket")) {
                RedirectView v = new RedirectView(request.getRequestURL().toString());
                v.setExposeModelAttributes(false);
                v.setExposePathVariables(false);
                modelAndView.setView((View)v);
            }
        }
    }
}

