/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collections;
import java.util.HashMap;
import javax.servlet.Filter;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.security.RequestParameterPolicyEnforcementFilter;
import org.apereo.cas.security.ResponseHeadersEnforcementFilter;
import org.apereo.cas.web.support.CurrentCredentialsAndAuthenticationClearingFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CharacterEncodingFilter;

@Configuration(value="casFiltersConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasFiltersConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public FilterRegistrationBean characterEncodingFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new CharacterEncodingFilter(this.casProperties.getHttpWebRequest().getWeb().getEncoding(), this.casProperties.getHttpWebRequest().getWeb().isForceEncoding()));
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setName("characterEncodingFilter");
        return bean;
    }

    @RefreshScope
    @Bean
    public FilterRegistrationBean responseHeadersSecurityFilter() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("enableCacheControl", BooleanUtils.toStringTrueFalse((boolean)this.casProperties.getHttpWebRequest().getHeader().isCache()));
        initParams.put("enableXContentTypeOptions", BooleanUtils.toStringTrueFalse((boolean)this.casProperties.getHttpWebRequest().getHeader().isXcontent()));
        initParams.put("enableStrictTransportSecurity", BooleanUtils.toStringTrueFalse((boolean)this.casProperties.getHttpWebRequest().getHeader().isHsts()));
        initParams.put("enableXFrameOptions", BooleanUtils.toStringTrueFalse((boolean)this.casProperties.getHttpWebRequest().getHeader().isXframe()));
        initParams.put("enableXSSProtection", BooleanUtils.toStringTrueFalse((boolean)this.casProperties.getHttpWebRequest().getHeader().isXss()));
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ResponseHeadersEnforcementFilter());
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setInitParameters(initParams);
        bean.setName("responseHeadersSecurityFilter");
        return bean;
    }

    @RefreshScope
    @Bean
    public FilterRegistrationBean requestParameterSecurityFilter() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("parametersToCheck", this.casProperties.getHttpWebRequest().getParamsToCheck());
        initParams.put("charactersToForbid", "none");
        initParams.put("allowMultiValuedParameters", BooleanUtils.toStringTrueFalse((boolean)this.casProperties.getHttpWebRequest().isAllowMultiValueParameters()));
        initParams.put("onlyPostParameters", this.casProperties.getHttpWebRequest().getOnlyPostParams());
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new RequestParameterPolicyEnforcementFilter());
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setName("requestParameterSecurityFilter");
        bean.setInitParameters(initParams);
        return bean;
    }

    @Bean
    public FilterRegistrationBean currentCredentialsAndAuthenticationClearingFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new CurrentCredentialsAndAuthenticationClearingFilter());
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setName("currentCredentialsAndAuthenticationClearingFilter");
        bean.setAsyncSupported(true);
        return bean;
    }
}

