/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.valves.ExtendedAccessLogValve;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.AbstractProtocol;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.ServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.SocketUtils;

@Configuration(value="casEmbeddedContainerConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnClass(name={"org.apache.catalina.startup.Tomcat"})
public class CasEmbeddedContainerConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasEmbeddedContainerConfiguration.class);
    @Autowired
    private ServerProperties serverProperties;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
        ServerProperties.Ajp ajp = this.casProperties.getServer().getAjp();
        if (ajp.isEnabled()) {
            LOGGER.debug("Creating AJP configuration for the embedded tomcat container...");
            Connector ajpConnector = new Connector(ajp.getProtocol());
            ajpConnector.setProtocol(ajp.getProtocol());
            ajpConnector.setPort(ajp.getPort());
            ajpConnector.setSecure(ajp.isSecure());
            ajpConnector.setAllowTrace(ajp.isAllowTrace());
            ajpConnector.setScheme(ajp.getScheme());
            ajpConnector.setAsyncTimeout((long)ajp.getAsyncTimeout());
            ajpConnector.setEnableLookups(ajp.isEnableLookups());
            ajpConnector.setMaxPostSize(ajp.getMaxPostSize());
            if (ajp.getProxyPort() > 0) {
                LOGGER.debug("Set AJP proxy port to {}", (Object)ajp.getProxyPort());
                ajpConnector.setProxyPort(ajp.getProxyPort());
            }
            if (ajp.getRedirectPort() > 0) {
                LOGGER.debug("Set AJP redirect port to {}", (Object)ajp.getRedirectPort());
                ajpConnector.setRedirectPort(ajp.getRedirectPort());
            }
            tomcat.addAdditionalTomcatConnectors(new Connector[]{ajpConnector});
        }
        if (this.casProperties.getServer().getHttp().isEnabled()) {
            LOGGER.debug("Creating HTTP configuration for the embedded tomcat container...");
            Connector connector2 = new Connector(this.casProperties.getServer().getHttp().getProtocol());
            int port = this.casProperties.getServer().getHttp().getPort();
            if (port <= 0) {
                port = SocketUtils.findAvailableTcpPort();
            }
            LOGGER.debug("Set HTTP port to {}", (Object)port);
            connector2.setPort(port);
            tomcat.addAdditionalTomcatConnectors(new Connector[]{connector2});
        }
        tomcat.getAdditionalTomcatConnectors().stream().filter(connector -> connector.getProtocolHandler() instanceof AbstractProtocol).forEach(connector -> {
            AbstractProtocol handler = (AbstractProtocol)connector.getProtocolHandler();
            handler.setSoTimeout(this.casProperties.getServer().getConnectionTimeout());
            handler.setConnectionTimeout(this.casProperties.getServer().getConnectionTimeout());
        });
        if (this.casProperties.getServer().getExtAccessLog().isEnabled() && StringUtils.isNotBlank((CharSequence)this.casProperties.getServer().getExtAccessLog().getPattern())) {
            LOGGER.debug("Creating extended access log valve configuration for the embedded tomcat container...");
            ExtendedAccessLogValve valve = new ExtendedAccessLogValve();
            valve.setPattern(this.casProperties.getServer().getExtAccessLog().getPattern());
            if (StringUtils.isBlank((CharSequence)this.casProperties.getServer().getExtAccessLog().getDirectory())) {
                valve.setDirectory(this.serverProperties.getTomcat().getAccesslog().getDirectory());
            } else {
                valve.setDirectory(this.casProperties.getServer().getExtAccessLog().getDirectory());
            }
            valve.setPrefix(this.casProperties.getServer().getExtAccessLog().getPrefix());
            valve.setSuffix(this.casProperties.getServer().getExtAccessLog().getSuffix());
            valve.setAsyncSupported(true);
            valve.setEnabled(true);
            valve.setRotatable(true);
            valve.setBuffered(true);
            tomcat.addContextValves(new Valve[]{valve});
            tomcat.addEngineValves(new Valve[]{valve});
        }
        return tomcat;
    }
}

