/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.view.Cas20ResponseView;

public class Cas30ResponseView
extends Cas20ResponseView {
    private boolean releaseProtocolAttributes = true;
    private String authenticationContextAttribute;

    @Override
    protected void prepareMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.prepareMergedOutputModel(model, request, response);
        Service service = super.getServiceFrom(model);
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(this.getCasPrincipalAttributes(model, registeredService));
        if (this.releaseProtocolAttributes) {
            attributes.putAll(this.getCasProtocolAuthenticationAttributes(model, registeredService));
        }
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attributes, model, registeredService);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attributes, model, registeredService);
        this.putCasResponseAttributesIntoModel(model, attributes, registeredService);
    }

    protected Map<String, Object> getCasProtocolAuthenticationAttributes(Map<String, Object> model, RegisteredService registeredService) {
        HashMap<String, Object> filteredAuthenticationAttributes = new HashMap<String, Object>(this.getAuthenticationAttributes(model));
        filteredAuthenticationAttributes.put("authenticationDate", Collections.singleton(this.getAuthenticationDate(model)));
        filteredAuthenticationAttributes.put("isFromNewLogin", Collections.singleton(this.isAssertionBackedByNewLogin(model)));
        filteredAuthenticationAttributes.put("longTermAuthenticationRequestTokenUsed", Collections.singleton(this.isRememberMeAuthentication(model)));
        Optional contextProvider = this.getSatisfiedMultifactorAuthenticationProvider(model);
        if (contextProvider.isPresent() && StringUtils.isNotBlank((CharSequence)this.authenticationContextAttribute)) {
            filteredAuthenticationAttributes.put(this.authenticationContextAttribute, Collections.singleton(((MultifactorAuthenticationProvider)contextProvider.get()).getId()));
        }
        return filteredAuthenticationAttributes;
    }

    protected Map<String, Object> getCasPrincipalAttributes(Map<String, Object> model, RegisteredService registeredService) {
        return super.getPrincipalAttributesAsMultiValuedAttributes(model);
    }

    protected void putCasResponseAttributesIntoModel(Map<String, Object> model, Map<String, Object> attributes, RegisteredService registeredService) {
        Map encodedAttributes = this.casAttributeEncoder.encodeAttributes(attributes, this.getServiceFrom(model));
        super.putIntoModel(model, "attributes", (Object)encodedAttributes);
        ArrayList formattedAttributes = new ArrayList(encodedAttributes.size());
        encodedAttributes.forEach((k, v) -> {
            Set values = CollectionUtils.convertValueToCollection((Object)v);
            values.forEach(value -> {
                StringBuilder builder = new StringBuilder();
                builder.append("<cas:".concat((String)k).concat(">"));
                builder.append(StringEscapeUtils.escapeXml10((String)value.toString().trim()));
                builder.append("</cas:".concat((String)k).concat(">"));
                formattedAttributes.add(builder.toString());
            });
        });
        super.putIntoModel(model, "formattedAttributes", formattedAttributes);
    }

    public void setReleaseProtocolAttributes(boolean releaseProtocolAttributes) {
        this.releaseProtocolAttributes = releaseProtocolAttributes;
    }

    public void setAuthenticationContextAttribute(String authenticationContextAttribute) {
        this.authenticationContextAttribute = authenticationContextAttribute;
    }
}

