/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.support.CasAttributeEncoder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.validation.ValidationSpecification;
import org.apereo.cas.web.LegacyValidateController;
import org.apereo.cas.web.ProxyController;
import org.apereo.cas.web.ProxyValidateController;
import org.apereo.cas.web.ServiceValidateController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.v3.V3ProxyValidateController;
import org.apereo.cas.web.v3.V3ServiceValidateController;
import org.apereo.cas.web.view.Cas10ResponseView;
import org.apereo.cas.web.view.Cas20ResponseView;
import org.apereo.cas.web.view.Cas30JsonResponseView;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="casValidationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasValidationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private CasAttributeEncoder casAttributeEncoder;
    @Autowired
    @Qualifier(value="cas3SuccessView")
    private View cas3SuccessView;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private ValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas20ProtocolValidationSpecification")
    private ValidationSpecification cas20ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas10ProtocolValidationSpecification")
    private ValidationSpecification cas10ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="cas2ServiceFailureView")
    private View cas2ServiceFailureView;
    @Autowired
    @Qualifier(value="cas2SuccessView")
    private View cas2SuccessView;
    @Autowired
    @Qualifier(value="cas3ServiceFailureView")
    private View cas3ServiceFailureView;
    @Autowired
    @Qualifier(value="proxy10Handler")
    private ProxyHandler proxy10Handler;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ProxyHandler proxy20Handler;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultArgumentExtractor")
    private ArgumentExtractor argumentExtractor;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;

    @Bean
    public View cas1ServiceSuccessView() {
        Cas10ResponseView v = new Cas10ResponseView();
        v.setSuccessResponse(true);
        v.setCasAttributeEncoder(this.casAttributeEncoder);
        return v;
    }

    @Bean
    public View cas1ServiceFailureView() {
        Cas10ResponseView v = new Cas10ResponseView();
        v.setSuccessResponse(false);
        v.setCasAttributeEncoder(this.casAttributeEncoder);
        return v;
    }

    @Bean
    public View cas2ServiceSuccessView() {
        Cas20ResponseView v = new Cas20ResponseView();
        v.setView(this.cas2SuccessView);
        v.setCasAttributeEncoder(this.casAttributeEncoder);
        return v;
    }

    @Bean
    public View cas3ServiceJsonView() {
        Cas30JsonResponseView s = new Cas30JsonResponseView();
        s.setAuthenticationContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        s.setReleaseProtocolAttributes(this.casProperties.getView().getCas3().isReleaseProtocolAttributes());
        s.setCasAttributeEncoder(this.casAttributeEncoder);
        s.setView(this.cas3SuccessView);
        s.setServicesManager(this.servicesManager);
        return s;
    }

    @Bean
    public View cas3ServiceSuccessView() {
        Cas30ResponseView s = new Cas30ResponseView();
        s.setAuthenticationContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        s.setReleaseProtocolAttributes(this.casProperties.getView().getCas3().isReleaseProtocolAttributes());
        s.setCasAttributeEncoder(this.casAttributeEncoder);
        s.setView(this.cas3SuccessView);
        s.setServicesManager(this.servicesManager);
        return s;
    }

    @Bean
    public V3ServiceValidateController v3ServiceValidateController() {
        V3ServiceValidateController c = new V3ServiceValidateController();
        c.setValidationSpecification(this.cas20WithoutProxyProtocolValidationSpecification);
        c.setSuccessView(this.cas3ServiceSuccessView());
        c.setFailureView(this.cas3ServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(this.argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @Bean
    public V3ProxyValidateController v3ProxyValidateController() {
        V3ProxyValidateController c = new V3ProxyValidateController();
        c.setValidationSpecification(this.cas20ProtocolValidationSpecification);
        c.setSuccessView(this.cas3ServiceSuccessView());
        c.setFailureView(this.cas3ServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(this.argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @Bean
    public ProxyValidateController proxyValidateController() {
        ProxyValidateController c = new ProxyValidateController();
        c.setValidationSpecification(this.cas20ProtocolValidationSpecification);
        c.setSuccessView(this.cas3ServiceSuccessView());
        c.setFailureView(this.cas3ServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(this.argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @Bean
    public LegacyValidateController legacyValidateController() {
        LegacyValidateController c = new LegacyValidateController();
        c.setValidationSpecification(this.cas10ProtocolValidationSpecification);
        c.setSuccessView(this.cas1ServiceSuccessView());
        c.setFailureView(this.cas1ServiceFailureView());
        c.setProxyHandler(this.proxy10Handler);
        c.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(this.argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @Bean
    public ProxyController proxyController() {
        ProxyController c = new ProxyController();
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setWebApplicationServiceFactory(this.webApplicationServiceFactory);
        return c;
    }

    @Bean
    public ServiceValidateController serviceValidateController() {
        ServiceValidateController c = new ServiceValidateController();
        c.setValidationSpecification(this.cas20WithoutProxyProtocolValidationSpecification);
        c.setSuccessView(this.cas2ServiceSuccessView());
        c.setFailureView(this.cas2ServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(this.argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }
}

