/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HttpBasedServiceCredential;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.AbstractTicketValidationException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationContextTicketValidationException;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.Pair;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.ValidationResponseType;
import org.apereo.cas.validation.ValidationSpecification;
import org.apereo.cas.web.AbstractDelegateController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public abstract class AbstractServiceValidateController
extends AbstractDelegateController {
    private ValidationSpecification validationSpecification;
    private AuthenticationSystemSupport authenticationSystemSupport;
    private ServicesManager servicesManager;
    private CentralAuthenticationService centralAuthenticationService;
    private ProxyHandler proxyHandler;
    private View successView;
    private View failureView;
    private ArgumentExtractor argumentExtractor;
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    private AuthenticationContextValidator authenticationContextValidator;
    private View jsonView;
    private String authnContextAttribute;

    protected Credential getServiceCredentialsFromRequest(WebApplicationService service, HttpServletRequest request) {
        String pgtUrl = request.getParameter("pgtUrl");
        if (StringUtils.hasText((String)pgtUrl)) {
            try {
                RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
                this.verifyRegisteredServiceProperties(registeredService, (Service)service);
                return new HttpBasedServiceCredential(new URL(pgtUrl), registeredService);
            }
            catch (Exception e) {
                this.logger.error("Error constructing {}", (Object)"pgtUrl", (Object)e);
            }
        }
        return null;
    }

    protected Pair<Boolean, Optional<MultifactorAuthenticationProvider>> validateAuthenticationContext(Assertion assertion, HttpServletRequest request) {
        this.logger.debug("Locating the primary authentication associated with this service request {}", (Object)assertion.getService());
        RegisteredService service = this.servicesManager.findServiceBy(assertion.getService());
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)assertion.getService(), (RegisteredService)service);
        Map providers = this.applicationContext.getBeansOfType(MultifactorAuthenticationProvider.class, false, true);
        Authentication authentication = assertion.getPrimaryAuthentication();
        Optional requestedContext = this.multifactorTriggerSelectionStrategy.resolve(providers.values(), request, service, authentication.getPrincipal());
        if (!requestedContext.isPresent()) {
            this.logger.debug("No particular authentication context is required for this request");
            return new Pair((Object)Boolean.TRUE, Optional.empty());
        }
        Pair result = this.authenticationContextValidator.validate(authentication, (String)requestedContext.get(), service);
        return result;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.setRequiredFields(new String[]{"renew"});
    }

    private TicketGrantingTicket handleProxyGrantingTicketDelivery(String serviceTicketId, Credential credential) throws AuthenticationException, AbstractTicketException {
        ServiceTicket serviceTicket = (ServiceTicket)this.centralAuthenticationService.getTicket(serviceTicketId, ServiceTicket.class);
        AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(serviceTicket.getService(), new Credential[]{credential});
        ProxyGrantingTicket proxyGrantingTicketId = this.centralAuthenticationService.createProxyGrantingTicket(serviceTicketId, authenticationResult);
        this.logger.debug("Generated proxy-granting ticket [{}] off of service ticket [{}] and credential [{}]", new Object[]{proxyGrantingTicketId.getId(), serviceTicketId, credential});
        return proxyGrantingTicketId;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceTicketId;
        WebApplicationService service = this.argumentExtractor.extractService(request);
        String string = serviceTicketId = service != null ? service.getArtifactId() : null;
        if (service == null || serviceTicketId == null) {
            this.logger.debug("Could not identify service and/or service ticket for service: [{}]", (Object)service);
            return this.generateErrorView("INVALID_REQUEST", null, request, service);
        }
        try {
            return this.handleTicketValidation(request, service, serviceTicketId);
        }
        catch (AbstractTicketValidationException e) {
            String code = e.getCode();
            return this.generateErrorView(code, new Object[]{serviceTicketId, e.getOriginalService().getId(), service.getId()}, request, service);
        }
        catch (AbstractTicketException e) {
            return this.generateErrorView(e.getCode(), new Object[]{serviceTicketId}, request, service);
        }
        catch (UnauthorizedProxyingException e) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE_PROXY", new Object[]{service.getId()}, request, service);
        }
        catch (UnauthorizedServiceException e) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE", null, request, service);
        }
    }

    protected ModelAndView handleTicketValidation(HttpServletRequest request, WebApplicationService service, String serviceTicketId) {
        Assertion assertion;
        TicketGrantingTicket proxyGrantingTicketId = null;
        Credential serviceCredential = this.getServiceCredentialsFromRequest(service, request);
        if (serviceCredential != null) {
            try {
                proxyGrantingTicketId = this.handleProxyGrantingTicketDelivery(serviceTicketId, serviceCredential);
            }
            catch (AuthenticationException e) {
                this.logger.warn("Failed to authenticate service credential {}", (Object)serviceCredential);
                return this.generateErrorView("INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()}, request, service);
            }
            catch (InvalidTicketException e) {
                this.logger.error("Failed to create proxy granting ticket due to an invalid ticket for {}", (Object)serviceCredential, (Object)e);
                return this.generateErrorView(e.getCode(), new Object[]{serviceTicketId}, request, service);
            }
            catch (AbstractTicketException e) {
                this.logger.error("Failed to create proxy granting ticket for {}", (Object)serviceCredential, (Object)e);
                return this.generateErrorView(e.getCode(), new Object[]{serviceCredential.getId()}, request, service);
            }
        }
        if (!this.validateAssertion(request, serviceTicketId, assertion = this.centralAuthenticationService.validateServiceTicket(serviceTicketId, (Service)service))) {
            return this.generateErrorView("INVALID_TICKET", new Object[]{serviceTicketId}, request, service);
        }
        Pair<Boolean, Optional<MultifactorAuthenticationProvider>> ctxResult = this.validateAuthenticationContext(assertion, request);
        if (!((Boolean)ctxResult.getFirst()).booleanValue()) {
            throw new UnsatisfiedAuthenticationContextTicketValidationException(assertion.getService());
        }
        String proxyIou = null;
        if (serviceCredential != null && this.proxyHandler.canHandle(serviceCredential)) {
            proxyIou = this.handleProxyIouDelivery(serviceCredential, proxyGrantingTicketId);
            if (StringUtils.isEmpty((Object)proxyIou)) {
                return this.generateErrorView("INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()}, request, service);
            }
        } else {
            this.logger.debug("No service credentials specified, and/or the proxy handler [{}] cannot handle credentials", (Object)this.proxyHandler);
        }
        this.onSuccessfulValidation(serviceTicketId, assertion);
        this.logger.debug("Successfully validated service ticket {} for service [{}]", (Object)serviceTicketId, (Object)service.getId());
        return this.generateSuccessView(assertion, proxyIou, service, request, (Optional)ctxResult.getSecond(), proxyGrantingTicketId);
    }

    private String handleProxyIouDelivery(Credential serviceCredential, TicketGrantingTicket proxyGrantingTicketId) {
        return this.proxyHandler.handle(serviceCredential, proxyGrantingTicketId);
    }

    private boolean validateAssertion(HttpServletRequest request, String serviceTicketId, Assertion assertion) {
        this.validationSpecification.reset();
        ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)this.validationSpecification, "validationSpecification");
        this.initBinder(request, binder);
        binder.bind((ServletRequest)request);
        if (!this.validationSpecification.isSatisfiedBy(assertion, request)) {
            this.logger.warn("Service ticket [{}] does not satisfy validation specification.", (Object)serviceTicketId);
            return false;
        }
        return true;
    }

    protected void onSuccessfulValidation(String serviceTicketId, Assertion assertion) {
    }

    private ModelAndView generateErrorView(String code, Object[] args, HttpServletRequest request, WebApplicationService service) {
        ModelAndView modelAndView = this.getModelAndView(request, false, service);
        String convertedDescription = this.applicationContext.getMessage(code, args, code, request.getLocale());
        modelAndView.addObject("code", (Object)StringEscapeUtils.escapeHtml4((String)code));
        modelAndView.addObject("description", (Object)StringEscapeUtils.escapeHtml4((String)convertedDescription));
        return modelAndView;
    }

    private ModelAndView getModelAndView(HttpServletRequest request, boolean isSuccess, WebApplicationService service) {
        ValidationResponseType type = service != null ? service.getFormat() : ValidationResponseType.XML;
        String format = request.getParameter("format");
        if (!StringUtils.isEmpty((Object)format)) {
            try {
                type = ValidationResponseType.valueOf((String)format.toUpperCase());
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (type == ValidationResponseType.JSON) {
            return new ModelAndView(this.jsonView);
        }
        return new ModelAndView(isSuccess ? this.successView : this.failureView);
    }

    private ModelAndView generateSuccessView(Assertion assertion, String proxyIou, WebApplicationService service, HttpServletRequest request, Optional<MultifactorAuthenticationProvider> contextProvider, TicketGrantingTicket proxyGrantingTicket) {
        Map<String, ?> augmentedModelObjects;
        ModelAndView modelAndView = this.getModelAndView(request, true, service);
        modelAndView.addObject("assertion", (Object)assertion);
        modelAndView.addObject("service", (Object)service);
        modelAndView.addObject("pgtIou", (Object)proxyIou);
        if (proxyGrantingTicket != null) {
            modelAndView.addObject("proxyGrantingTicket", (Object)proxyGrantingTicket.getId());
        }
        if (contextProvider.isPresent()) {
            modelAndView.addObject(this.authnContextAttribute, contextProvider);
        }
        if ((augmentedModelObjects = this.augmentSuccessViewModelObjects(assertion)) != null) {
            modelAndView.addAllObjects(augmentedModelObjects);
        }
        return modelAndView;
    }

    protected Map<String, ?> augmentSuccessViewModelObjects(Assertion assertion) {
        return Collections.emptyMap();
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setArgumentExtractor(ArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public void setMultifactorTriggerSelectionStrategy(MultifactorTriggerSelectionStrategy strategy) {
        this.multifactorTriggerSelectionStrategy = strategy;
    }

    public void setValidationSpecification(ValidationSpecification validationSpecificationClass) {
        this.validationSpecification = validationSpecificationClass;
    }

    public void setFailureView(View failureView) {
        this.failureView = failureView;
    }

    public View getFailureView() {
        return this.failureView;
    }

    public void setSuccessView(View successView) {
        this.successView = successView;
    }

    public View getSuccessView() {
        return this.successView;
    }

    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    private void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) {
        if (registeredService == null) {
            String msg = String.format("Service [%s] is not found in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not enabled in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }

    public void setAuthenticationSystemSupport(AuthenticationSystemSupport authenticationSystemSupport) {
        this.authenticationSystemSupport = authenticationSystemSupport;
    }

    public void setAuthenticationContextValidator(AuthenticationContextValidator authenticationContextValidator) {
        this.authenticationContextValidator = authenticationContextValidator;
    }

    public void setJsonView(View jsonView) {
        this.jsonView = jsonView;
    }

    public void setAuthnContextAttribute(String authnContextAttribute) {
        this.authnContextAttribute = authnContextAttribute;
    }
}

