/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.support.AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter;
import org.apereo.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionByIpAddressHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionCleaner;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casThrottlingConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasThrottlingConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @ConditionalOnMissingBean(name={"authenticationThrottle"})
    @Bean(name={"defaultAuthenticationThrottle", "authenticationThrottle"})
    public ThrottledSubmissionHandlerInterceptor defaultAuthenticationThrottle() {
        if (this.casProperties.getAuthn().getThrottle().getFailure().getThreshold() > 0 && this.casProperties.getAuthn().getThrottle().getFailure().getRangeSeconds() > 0) {
            if (StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getThrottle().getUsernameParameter())) {
                return this.inMemoryIpAddressUsernameThrottle();
            }
            return this.inMemoryIpAddressThrottle();
        }
        return CasThrottlingConfiguration.neverThrottle();
    }

    @Bean
    public Runnable throttleSubmissionCleaner(@Qualifier(value="authenticationThrottle") ThrottledSubmissionHandlerInterceptor adapter) {
        return new InMemoryThrottledSubmissionCleaner(adapter);
    }

    private ThrottledSubmissionHandlerInterceptor inMemoryIpAddressUsernameThrottle() {
        return this.configureInMemoryInterceptorAdaptor(new InMemoryThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter());
    }

    private ThrottledSubmissionHandlerInterceptor inMemoryIpAddressThrottle() {
        return this.configureInMemoryInterceptorAdaptor(new InMemoryThrottledSubmissionByIpAddressHandlerInterceptorAdapter());
    }

    private static ThrottledSubmissionHandlerInterceptor neverThrottle() {
        return new ThrottledSubmissionHandlerInterceptor(){};
    }

    private AbstractThrottledSubmissionHandlerInterceptorAdapter configureThrottleHandlerInterceptorAdaptor(AbstractThrottledSubmissionHandlerInterceptorAdapter interceptorAdapter) {
        interceptorAdapter.setUsernameParameter(this.casProperties.getAuthn().getThrottle().getUsernameParameter());
        interceptorAdapter.setFailureThreshold(this.casProperties.getAuthn().getThrottle().getFailure().getThreshold());
        interceptorAdapter.setFailureRangeInSeconds(this.casProperties.getAuthn().getThrottle().getFailure().getRangeSeconds());
        return interceptorAdapter;
    }

    private ThrottledSubmissionHandlerInterceptor configureInMemoryInterceptorAdaptor(AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter interceptorAdapter) {
        return this.configureThrottleHandlerInterceptorAdaptor(interceptorAdapter);
    }
}

