/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class AbstractThrottledSubmissionHandlerInterceptorAdapter
extends HandlerInterceptorAdapter
implements ThrottledSubmissionHandlerInterceptor {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private int failureThreshold;
    private int failureRangeInSeconds;
    private String usernameParameter;
    private double thresholdRate;

    @PostConstruct
    public void afterPropertiesSet() {
        this.thresholdRate = (double)this.failureThreshold / (double)this.failureRangeInSeconds;
        this.logger.debug("Calculated threshold rate as {}", (Object)this.thresholdRate);
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        if (!HttpMethod.POST.name().equals(request.getMethod())) {
            return true;
        }
        if (this.exceedsThreshold(request)) {
            this.recordThrottle(request);
            request.setAttribute("CAS_ACCESS_DENIED_REASON", (Object)"screen.blocked.message");
            response.sendError(403, "Access Denied for user [" + StringEscapeUtils.escapeHtml4((String)request.getParameter(this.usernameParameter)) + "] from IP Address [" + request.getRemoteAddr() + ']');
            return false;
        }
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        boolean recordEvent;
        if (!HttpMethod.POST.name().equals(request.getMethod())) {
            return;
        }
        boolean bl = recordEvent = response.getStatus() != 201 && response.getStatus() != 200;
        if (recordEvent) {
            this.logger.debug("Recording submission failure for {}", (Object)request.getRequestURI());
            this.recordSubmissionFailure(request);
        }
    }

    public void setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public void setFailureRangeInSeconds(int failureRangeInSeconds) {
        this.failureRangeInSeconds = failureRangeInSeconds;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    protected double getThresholdRate() {
        return this.thresholdRate;
    }

    protected int getFailureThreshold() {
        return this.failureThreshold;
    }

    protected int getFailureRangeInSeconds() {
        return this.failureRangeInSeconds;
    }

    protected String getUsernameParameter() {
        return this.usernameParameter;
    }

    protected void recordThrottle(HttpServletRequest request) {
        this.logger.warn("Throttling submission from {}. More than {} failed login attempts within {} seconds. Authentication attempt exceeds the failure threshold {}", new Object[]{request.getRemoteAddr(), this.failureThreshold, this.failureRangeInSeconds, this.failureThreshold});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("failureThreshold", this.failureThreshold).append("failureRangeInSeconds", this.failureRangeInSeconds).append("usernameParameter", (Object)this.usernameParameter).append("thresholdRate", this.thresholdRate).toString();
    }
}

