/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionHandlerInterceptor;

public abstract class AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter
implements InMemoryThrottledSubmissionHandlerInterceptor {
    private static final double SUBMISSION_RATE_DIVIDEND = 1000.0;
    private ConcurrentMap<String, ZonedDateTime> ipMap = new ConcurrentHashMap<String, ZonedDateTime>();

    @Override
    public boolean exceedsThreshold(HttpServletRequest request) {
        ZonedDateTime last = (ZonedDateTime)this.ipMap.get(this.constructKey(request));
        return last != null && AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter.submissionRate(ZonedDateTime.now(ZoneOffset.UTC), last) > this.getThresholdRate();
    }

    @Override
    public void recordSubmissionFailure(HttpServletRequest request) {
        this.ipMap.put(this.constructKey(request), ZonedDateTime.now(ZoneOffset.UTC));
    }

    @Override
    public void decrement() {
        this.logger.info("Beginning audit cleanup...");
        Set keys = this.ipMap.entrySet();
        this.logger.debug("Decrementing counts for throttler.  Starting key count: {}", (Object)keys.size());
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter.submissionRate(now, (ZonedDateTime)entry.getValue()) < this.getThresholdRate())) continue;
            this.logger.trace("Removing entry for key {}", entry.getKey());
            iter.remove();
        }
        this.logger.debug("Done decrementing count for throttler.");
    }

    private static double submissionRate(ZonedDateTime a, ZonedDateTime b) {
        return 1000.0 / (double)(a.toInstant().toEpochMilli() - b.toInstant().toEpochMilli());
    }
}

