/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web.config;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.RegisteredServiceThemeBasedViewResolver;
import org.apereo.cas.services.web.ServiceThemeResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.ViewResolver;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dialect.IPostProcessorDialect;
import org.thymeleaf.engine.AbstractTemplateHandler;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IText;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.postprocessor.PostProcessor;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;

@Configuration(value="casThemesConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasThemesConfiguration {
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ThymeleafProperties thymeleafProperties;
    @Autowired
    @Qualifier(value="thymeleafViewResolver")
    private ThymeleafViewResolver thymeleafViewResolver;
    @Autowired
    @Qualifier(value="argumentExtractors")
    private List argumentExtractors;
    @Autowired
    @Qualifier(value="serviceThemeResolverSupportedBrowsers")
    private Map serviceThemeResolverSupportedBrowsers;

    @Bean
    public ViewResolver registeredServiceViewResolver() {
        RegisteredServiceThemeBasedViewResolver r = new RegisteredServiceThemeBasedViewResolver();
        r.setApplicationContext(this.thymeleafViewResolver.getApplicationContext());
        r.setCache(this.thymeleafProperties.isCache());
        if (!r.isCache()) {
            r.setCacheLimit(0);
        }
        r.setCacheUnresolved(this.thymeleafViewResolver.isCacheUnresolved());
        r.setCharacterEncoding(this.thymeleafViewResolver.getCharacterEncoding());
        r.setContentType(this.thymeleafViewResolver.getContentType());
        r.setExcludedViewNames(this.thymeleafViewResolver.getExcludedViewNames());
        r.setOrder(this.thymeleafViewResolver.getOrder());
        r.setRedirectContextRelative(this.thymeleafViewResolver.isRedirectContextRelative());
        r.setRedirectHttp10Compatible(this.thymeleafViewResolver.isRedirectHttp10Compatible());
        r.setStaticVariables(this.thymeleafViewResolver.getStaticVariables());
        SpringTemplateEngine engine = (SpringTemplateEngine)SpringTemplateEngine.class.cast(this.thymeleafViewResolver.getTemplateEngine());
        engine.addDialect((IDialect)new IPostProcessorDialect(){

            public int getDialectPostProcessorPrecedence() {
                return Integer.MAX_VALUE;
            }

            public Set<IPostProcessor> getPostProcessors() {
                return Sets.newHashSet((Object[])new IPostProcessor[]{new PostProcessor(TemplateMode.parse((String)CasThemesConfiguration.this.thymeleafProperties.getMode()), CasThymeleafOutputTemplateHandler.class, Integer.MAX_VALUE)});
            }

            public String getName() {
                return CasThymeleafOutputTemplateHandler.class.getSimpleName();
            }
        });
        r.setTemplateEngine((ITemplateEngine)engine);
        r.setViewNames(this.thymeleafViewResolver.getViewNames());
        r.setServicesManager(this.servicesManager);
        r.setArgumentExtractors(this.argumentExtractors);
        r.setPrefix(this.thymeleafProperties.getPrefix());
        r.setSuffix(this.thymeleafProperties.getSuffix());
        return r;
    }

    @Bean(name={"serviceThemeResolver", "themeResolver"})
    public ThemeResolver serviceThemeResolver() {
        ServiceThemeResolver resolver = new ServiceThemeResolver();
        resolver.setDefaultThemeName(this.casProperties.getTheme().getDefaultThemeName());
        resolver.setServicesManager(this.servicesManager);
        resolver.setMobileBrowsers(this.serviceThemeResolverSupportedBrowsers);
        return resolver;
    }

    public static class CasThymeleafOutputTemplateHandler
    extends AbstractTemplateHandler {
        private boolean writeWhitespace;

        public void handleText(IText text) {
            String contentString = text.getText();
            if (!contentString.isEmpty() && contentString.trim().isEmpty()) {
                if (!this.writeWhitespace) {
                    return;
                }
                this.writeWhitespace = false;
            }
            super.handleText(text);
        }

        public void handleCloseElement(ICloseElementTag tag) {
            super.handleCloseElement(tag);
            this.writeWhitespace = true;
        }

        public void handleOpenElement(IOpenElementTag openElementTag) {
            super.handleOpenElement(openElementTag);
            this.writeWhitespace = true;
        }
    }
}

