/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.theme.AbstractThemeResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class ServiceThemeResolver
extends AbstractThemeResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceThemeResolver.class);
    private ServicesManager servicesManager;
    private Map<Pattern, String> overrides = new HashMap<Pattern, String>();

    public String resolveThemeName(HttpServletRequest request) {
        RegisteredService rService;
        RequestContext context;
        WebApplicationService service;
        if (this.servicesManager == null) {
            return this.getDefaultThemeName();
        }
        String userAgent = WebUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return this.getDefaultThemeName();
        }
        for (Map.Entry<Pattern, String> entry : this.overrides.entrySet()) {
            if (!entry.getKey().matcher(userAgent).matches()) continue;
            request.setAttribute("isMobile", (Object)"true");
            request.setAttribute("browserType", (Object)entry.getValue());
            break;
        }
        if ((service = WebUtils.getService((RequestContext)(context = RequestContextHolder.getRequestContext()))) != null && (rService = this.servicesManager.findServiceBy((Service)service)) != null && rService.getAccessStrategy().isServiceAccessAllowed() && StringUtils.isNotBlank((CharSequence)rService.getTheme())) {
            LOGGER.debug("Service [{}] is configured to use a custom theme [{}]", (Object)rService, (Object)rService.getTheme());
            CasThemeResourceBundleMessageSource messageSource = new CasThemeResourceBundleMessageSource();
            messageSource.setBasename(rService.getTheme());
            if (messageSource.doGetBundle(rService.getTheme(), request.getLocale()) != null) {
                LOGGER.debug("Found custom theme [{}] for service [{}]", (Object)rService.getTheme(), (Object)rService);
                return rService.getTheme();
            }
            LOGGER.warn("Custom theme {} for service {} cannot be located. Falling back to default theme...", (Object)rService.getTheme(), (Object)rService);
        }
        return this.getDefaultThemeName();
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setDefaultThemeName(String defaultThemeName) {
        super.setDefaultThemeName(defaultThemeName);
    }

    @Autowired
    @Qualifier(value="serviceThemeResolverSupportedBrowsers")
    public void setMobileBrowsers(Map mobileOverrides) {
        this.overrides = new HashMap<Pattern, String>();
        mobileOverrides.entrySet().forEach(e -> {
            Map.Entry entry = (Map.Entry)e;
            this.overrides.put(Pattern.compile((String)entry.getKey()), (String)entry.getValue());
        });
    }

    private static class CasThemeResourceBundleMessageSource
    extends ResourceBundleMessageSource {
        private CasThemeResourceBundleMessageSource() {
        }

        protected ResourceBundle doGetBundle(String basename, Locale locale) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
                if (bundle != null && !bundle.keySet().isEmpty()) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }
}

