/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.View;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.thymeleaf.spring4.view.AbstractThymeleafView;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;

public class RegisteredServiceThemeBasedViewResolver
extends ThymeleafViewResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceThemeBasedViewResolver.class);
    private ServicesManager servicesManager;
    private List argumentExtractors;
    private String prefix;
    private String suffix;

    protected View loadView(String viewName, Locale locale) throws Exception {
        WebApplicationService service;
        HttpServletResponse response;
        View view = super.loadView(viewName, locale);
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        if (requestContext != null) {
            HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
            response = WebUtils.getHttpServletResponse((RequestContext)requestContext);
            service = WebUtils.getService((List)this.argumentExtractors, (RequestContext)requestContext);
        } else {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromRequestAttributes();
            service = WebUtils.getService((List)this.argumentExtractors, (HttpServletRequest)request);
            response = WebUtils.getHttpServletResponseFromRequestAttributes();
        }
        if (service == null) {
            return view;
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService != null) {
            try {
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            }
            catch (Exception e) {
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
            }
        }
        if (registeredService != null && StringUtils.hasText((String)registeredService.getTheme()) && view instanceof AbstractThymeleafView) {
            LOGGER.debug("Attempting to locate views for service [{}] with theme [{}]", (Object)registeredService.getServiceId(), (Object)registeredService.getTheme());
            AbstractThymeleafView thymeleafView = (AbstractThymeleafView)view;
            String viewUrl = registeredService.getTheme() + '/' + thymeleafView.getTemplateName();
            String viewLocationUrl = this.getPrefix().concat(viewUrl).concat(this.getSuffix());
            LOGGER.debug("Attempting to locate view at {}", (Object)viewLocationUrl);
            TemplateLocation location = new TemplateLocation(viewLocationUrl);
            if (location.exists((ResourcePatternResolver)this.getApplicationContext())) {
                LOGGER.debug("Found view {}", (Object)viewUrl);
                thymeleafView.setTemplateName(viewUrl);
            } else {
                LOGGER.debug("View {} does not exist. Fallling back to default view at {}", (Object)viewLocationUrl, (Object)thymeleafView.getTemplateName());
            }
        }
        return view;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setArgumentExtractors(List argumentExtractors) {
        this.argumentExtractors = argumentExtractors;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

