/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.DefaultAuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.rest.CredentialFactory;
import org.apereo.cas.support.rest.DefaultCredentialFactory;
import org.apereo.cas.support.rest.TicketsResource;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(value="casRestConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasRestConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();
    @Autowired(required=false)
    private CredentialFactory credentialFactory = new DefaultCredentialFactory();
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(this.defaultRestAuthenticationThrottle()).addPathPatterns(new String[]{"/v1/**"});
    }

    @Bean
    public TicketsResource ticketResourceRestController() {
        TicketsResource r = new TicketsResource();
        r.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        r.setCredentialFactory(this.credentialFactory);
        r.setTicketRegistrySupport(this.ticketRegistrySupport);
        r.setWebApplicationServiceFactory(this.webApplicationServiceFactory);
        r.setCentralAuthenticationService(this.centralAuthenticationService);
        return r;
    }

    @ConditionalOnMissingBean(name={"restAuthenticationThrottle"})
    @Bean(name={"defaultRestAuthenticationThrottle", "restAuthenticationThrottle"})
    public HandlerInterceptor defaultRestAuthenticationThrottle() {
        String throttler = this.casProperties.getRest().getThrottler();
        if (StringUtils.isNotBlank((CharSequence)throttler) && this.applicationContext.containsBean(throttler)) {
            return (HandlerInterceptor)this.applicationContext.getBean(throttler, HandlerInterceptor.class);
        }
        return new HandlerInterceptorAdapter(){

            public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
                return true;
            }
        };
    }
}

