/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.support.rest.BadRequestException;
import org.apereo.cas.support.rest.CredentialFactory;
import org.apereo.cas.support.rest.DefaultCredentialFactory;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ticketResourceRestController")
public class TicketsResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketsResource.class);
    private CentralAuthenticationService centralAuthenticationService;
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();
    private CredentialFactory credentialFactory = new DefaultCredentialFactory();
    private ServiceFactory webApplicationServiceFactory;
    private TicketRegistrySupport ticketRegistrySupport;
    private final ObjectMapper jacksonObjectMapper = new ObjectMapper();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/v1/tickets"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createTicketGrantingTicket(@RequestBody MultiValueMap<String, String> requestBody, HttpServletRequest request) throws JsonProcessingException {
        try (Formatter fmt = new Formatter();){
            Credential credential = this.credentialFactory.fromRequestBody(requestBody);
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(null, new Credential[]{credential});
            TicketGrantingTicket tgtId = this.centralAuthenticationService.createTicketGrantingTicket(authenticationResult);
            URI ticketReference = new URI(request.getRequestURL().toString() + '/' + tgtId.getId());
            HttpHeaders headers = new HttpHeaders();
            headers.setLocation(ticketReference);
            headers.setContentType(MediaType.TEXT_HTML);
            fmt.format("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>", new Object[0]);
            fmt.format("%s %s", HttpStatus.CREATED, HttpStatus.CREATED.getReasonPhrase()).format("</title></head><body><h1>TGT Created</h1><form action=\"%s", ticketReference.toString()).format("\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\">", new Object[0]).format("<br><input type=\"submit\" value=\"Submit\"></form></body></html>", new Object[0]);
            ResponseEntity responseEntity = new ResponseEntity((Object)fmt.toString(), (MultiValueMap)headers, HttpStatus.CREATED);
            return responseEntity;
        }
        catch (AuthenticationException e) {
            List authnExceptions = e.getHandlerErrors().entrySet().stream().map(handlerErrorEntry -> ((Class)handlerErrorEntry.getValue()).getSimpleName()).collect(Collectors.toCollection(LinkedList::new));
            HashMap<String, List> errorsMap = new HashMap<String, List>();
            errorsMap.put("authentication_exceptions", authnExceptions);
            LOGGER.error(e.getMessage(), (Throwable)e);
            LOGGER.error(String.format("Caused by: %s", authnExceptions));
            return new ResponseEntity((Object)this.jacksonObjectMapper.writer().withDefaultPrettyPrinter().writeValueAsString(errorsMap), HttpStatus.UNAUTHORIZED);
        }
        catch (BadRequestException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/v1/tickets/{id:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<String> getTicketStatus(@PathVariable(value="id") String id) {
        try {
            this.centralAuthenticationService.getTicket(id);
            return new ResponseEntity((Object)id, HttpStatus.OK);
        }
        catch (InvalidTicketException e) {
            return new ResponseEntity((Object)"Ticket could not be found", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/v1/tickets/{tgtId:.+}"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createServiceTicket(@RequestBody MultiValueMap<String, String> requestBody, @PathVariable(value="tgtId") String tgtId) {
        try {
            String serviceId = (String)requestBody.getFirst((Object)"service");
            DefaultAuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            Service service = this.webApplicationServiceFactory.createService(serviceId);
            AuthenticationResult authenticationResult = builder.collect(this.ticketRegistrySupport.getAuthenticationFrom(tgtId)).build(service);
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(tgtId, service, authenticationResult);
            return new ResponseEntity((Object)serviceTicketId.getId(), HttpStatus.OK);
        }
        catch (InvalidTicketException e) {
            return new ResponseEntity((Object)"TicketGrantingTicket could not be found", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/v1/tickets/{tgtId:.+}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteTicketGrantingTicket(@PathVariable(value="tgtId") String tgtId) {
        this.centralAuthenticationService.destroyTicketGrantingTicket(tgtId);
        return new ResponseEntity((Object)tgtId, HttpStatus.OK);
    }

    public void setAuthenticationSystemSupport(AuthenticationSystemSupport authenticationSystemSupport) {
        this.authenticationSystemSupport = authenticationSystemSupport;
    }

    public void setWebApplicationServiceFactory(ServiceFactory webApplicationServiceFactory) {
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }

    public void setTicketRegistrySupport(TicketRegistrySupport ticketRegistrySupport) {
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public CentralAuthenticationService getCentralAuthenticationService() {
        return this.centralAuthenticationService;
    }

    public AuthenticationSystemSupport getAuthenticationSystemSupport() {
        return this.authenticationSystemSupport;
    }

    public CredentialFactory getCredentialFactory() {
        return this.credentialFactory;
    }

    public ServiceFactory getWebApplicationServiceFactory() {
        return this.webApplicationServiceFactory;
    }

    public TicketRegistrySupport getTicketRegistrySupport() {
        return this.ticketRegistrySupport;
    }

    public void setCredentialFactory(CredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
    }
}

