/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class VerifySecurityQuestionsAction
extends AbstractAction {
    private final PasswordManagementService passwordManagementService;

    public VerifySecurityQuestionsAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
        String username = requestContext.getFlowScope().getString("username");
        Map<String, String> questions = this.passwordManagementService.getSecurityQuestions(username);
        AtomicInteger i = new AtomicInteger(0);
        long c = questions.values().stream().filter(v -> {
            String answer = request.getParameter("q" + i.getAndIncrement());
            return answer.equals(v);
        }).count();
        if (c == (long)questions.size()) {
            return this.success();
        }
        return this.error();
    }
}

