/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class VerifyPasswordResetRequestAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyPasswordResetRequestAction.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    private PasswordManagementService passwordManagementService;

    public VerifyPasswordResetRequestAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
        String token = request.getParameter("t");
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.error("Password reset token is missing");
            return this.error();
        }
        String username = this.passwordManagementService.parseToken(token);
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.error("Password reset token could not be verified");
            return this.error();
        }
        ArrayList questions = Lists.newArrayList(this.passwordManagementService.getSecurityQuestions(username).keySet());
        if (questions.isEmpty()) {
            LOGGER.error("No security questions could be found for " + username);
            return this.error();
        }
        requestContext.getFlowScope().put("token", (Object)token);
        requestContext.getFlowScope().put("username", (Object)username);
        requestContext.getFlowScope().put("questions", (Object)questions);
        return this.success();
    }
}

