/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendPasswordResetInstructionsAction
extends AbstractAction {
    public static final String PARAMETER_NAME_TOKEN = "t";
    private static final Logger LOGGER = LoggerFactory.getLogger(SendPasswordResetInstructionsAction.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired(required=false)
    @Qualifier(value="mailSender")
    private JavaMailSender mailSender;
    private PasswordManagementService passwordManagementService;

    public SendPasswordResetInstructionsAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        if (this.mailSender == null) {
            LOGGER.warn("Mail settings are not defined");
            return this.error();
        }
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
        String username = request.getParameter("username");
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.warn("No username is provided");
            return this.error();
        }
        String to = this.passwordManagementService.findEmail(username);
        if (StringUtils.isBlank((CharSequence)to)) {
            LOGGER.warn("No recipient is provided");
            return this.error();
        }
        String token = this.passwordManagementService.createToken(username);
        String url = this.casProperties.getServer().getPrefix().concat("/pswdreset?t=").concat(token);
        if (this.sendPasswordResetEmailToAccount(to, url)) {
            return this.success();
        }
        LOGGER.error("Failed to notify account {}", (Object)to);
        return this.error();
    }

    protected boolean sendPasswordResetEmailToAccount(String to, String url) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message);
            helper.setTo(to);
            String text = String.format(this.casProperties.getAuthn().getPm().getReset().getText(), url);
            helper.setText(text);
            helper.setSubject(this.casProperties.getAuthn().getPm().getReset().getSubject());
            if (StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getPm().getReset().getFrom())) {
                helper.setFrom(this.casProperties.getAuthn().getPm().getReset().getFrom());
            }
            helper.setPriority(1);
            this.mailSender.send(message);
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

