/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PasswordChangeAction
extends AbstractAction {
    public static final String PASSWORD_UPDATE_SUCCESS = "passwordUpdateSuccess";
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordChangeAction.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    private PasswordManagementService passwordManagementService;

    public PasswordChangeAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        try {
            UsernamePasswordCredential c = (UsernamePasswordCredential)WebUtils.getCredential((RequestContext)requestContext);
            PasswordChangeBean bean = (PasswordChangeBean)requestContext.getFlowScope().get("password", PasswordChangeBean.class);
            if (this.passwordManagementService.change((Credential)c, bean)) {
                return new EventFactorySupport().event((Object)this, PASSWORD_UPDATE_SUCCESS);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        requestContext.getMessageContext().addMessage(new MessageBuilder().error().code("pm.updateFailure").defaultText("Could not update the account password").build());
        return this.error();
    }
}

