/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.ldap;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.util.LdapUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.ldaptive.pool.PooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class LdapPasswordManagementService
implements PasswordManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapPasswordManagementService.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    private CipherExecutor<String, String> cipherExecutor;

    public LdapPasswordManagementService(CipherExecutor<String, String> cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }

    @Override
    public String findEmail(String username) {
        try {
            PasswordManagementProperties.Ldap ldap = this.casProperties.getAuthn().getPm().getLdap();
            SearchFilter filter = Beans.newSearchFilter((String)ldap.getUserFilter(), (String[])new String[]{username});
            PooledConnectionFactory factory = Beans.newPooledConnectionFactory((AbstractLdapProperties)ldap);
            Response response = LdapUtils.executeSearchOperation((ConnectionFactory)factory, (String)ldap.getBaseDn(), (SearchFilter)filter);
            if (LdapUtils.containsResultEntry((Response)response)) {
                LdapEntry entry = ((SearchResult)response.getResult()).getEntry();
                LdapAttribute attr = entry.getAttribute(this.casProperties.getAuthn().getPm().getReset().getEmailAttribute());
                if (attr != null) {
                    String email = attr.getStringValue();
                    if (EmailValidator.getInstance().isValid(email)) {
                        return email;
                    }
                }
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public String createToken(String to) {
        try {
            String token = UUID.randomUUID().toString();
            JwtClaims claims = new JwtClaims();
            claims.setJwtId(token);
            claims.setIssuer(this.casProperties.getServer().getPrefix());
            claims.setAudience(this.casProperties.getServer().getPrefix());
            claims.setExpirationTimeMinutesInTheFuture(this.casProperties.getAuthn().getPm().getReset().getExpirationMinutes());
            claims.setIssuedAtToNow();
            ClientInfo holder = ClientInfoHolder.getClientInfo();
            claims.setStringClaim("origin", holder.getServerIpAddress());
            claims.setStringClaim("client", holder.getClientIpAddress());
            claims.setSubject(to);
            String json = claims.toJson();
            return (String)this.cipherExecutor.encode((Object)json);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean change(Credential credential, PasswordChangeBean bean) {
        Assert.notNull((Object)credential, (String)"Credential cannot be null");
        Assert.notNull((Object)bean, (String)"PasswordChangeBean cannot be null");
        try {
            PasswordManagementProperties.Ldap ldap = this.casProperties.getAuthn().getPm().getLdap();
            UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
            SearchFilter filter = Beans.newSearchFilter((String)ldap.getUserFilter(), (String[])new String[]{c.getId()});
            PooledConnectionFactory factory = Beans.newPooledConnectionFactory((AbstractLdapProperties)ldap);
            Response response = LdapUtils.executeSearchOperation((ConnectionFactory)factory, (String)ldap.getBaseDn(), (SearchFilter)filter);
            if (LdapUtils.containsResultEntry((Response)response)) {
                String dn = ((SearchResult)response.getResult()).getEntry().getDn();
                LOGGER.debug("Updating account password for {}", (Object)dn);
                if (LdapUtils.executePasswordModifyOperation((String)dn, (ConnectionFactory)factory, (String)c.getPassword(), (String)bean.getPassword(), (PasswordManagementProperties.Ldap.LdapType)this.casProperties.getAuthn().getPm().getLdap().getType())) {
                    LOGGER.debug("Successfully updated the account password for {}", (Object)dn);
                    return true;
                }
                LOGGER.error("Could not update the LDAP entry's password for {} and base DN {}", (Object)filter.format(), (Object)ldap.getBaseDn());
            } else {
                LOGGER.error("Could not locate an LDAP entry for {} and base DN {}", (Object)filter.format(), (Object)ldap.getBaseDn());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public String parseToken(String token) {
        try {
            String json = (String)this.cipherExecutor.decode((Object)token);
            JwtClaims claims = JwtClaims.parse((String)json);
            if (!claims.getIssuer().equals(this.casProperties.getServer().getPrefix())) {
                LOGGER.error("Token issuer does not match CAS");
                return null;
            }
            if (claims.getAudience().isEmpty() || !((String)claims.getAudience().get(0)).equals(this.casProperties.getServer().getPrefix())) {
                LOGGER.error("Token audience does not match CAS");
                return null;
            }
            if (StringUtils.isBlank((CharSequence)claims.getSubject())) {
                LOGGER.error("Token has no subject identifier");
                return null;
            }
            ClientInfo holder = ClientInfoHolder.getClientInfo();
            if (!claims.getStringClaimValue("origin").equals(holder.getServerIpAddress())) {
                LOGGER.error("Token origin does not match CAS");
                return null;
            }
            if (!claims.getStringClaimValue("client").equals(holder.getClientIpAddress())) {
                LOGGER.error("Token client does not match CAS");
                return null;
            }
            if (claims.getExpirationTime().isBefore(NumericDate.now())) {
                LOGGER.error("Token has expired.");
                return null;
            }
            return claims.getSubject();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, String> getSecurityQuestions(String username) {
        LinkedHashMap set = Maps.newLinkedHashMap();
        try {
            PasswordManagementProperties.Ldap ldap = this.casProperties.getAuthn().getPm().getLdap();
            SearchFilter filter = Beans.newSearchFilter((String)ldap.getUserFilter(), (String[])new String[]{username});
            PooledConnectionFactory factory = Beans.newPooledConnectionFactory((AbstractLdapProperties)ldap);
            Response response = LdapUtils.executeSearchOperation((ConnectionFactory)factory, (String)ldap.getBaseDn(), (SearchFilter)filter);
            if (LdapUtils.containsResultEntry((Response)response)) {
                LdapEntry entry = ((SearchResult)response.getResult()).getEntry();
                Map qs = this.casProperties.getAuthn().getPm().getReset().getSecurityQuestionsAttributes();
                qs.forEach((k, v) -> {
                    LdapAttribute q = entry.getAttribute(k);
                    LdapAttribute a = entry.getAttribute(v);
                    if (q != null && a != null && StringUtils.isNotBlank((CharSequence)q.getStringValue()) && StringUtils.isNotBlank((CharSequence)a.getStringValue())) {
                        set.put(q.getStringValue(), a.getStringValue());
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return set;
    }
}

