/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetTokenCipherExecutor;
import org.apereo.cas.pm.PasswordValidator;
import org.apereo.cas.pm.ldap.LdapPasswordManagementService;
import org.apereo.cas.pm.web.flow.InitPasswordChangeAction;
import org.apereo.cas.pm.web.flow.InitPasswordResetAction;
import org.apereo.cas.pm.web.flow.PasswordChangeAction;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowConfigurer;
import org.apereo.cas.pm.web.flow.SendPasswordResetInstructionsAction;
import org.apereo.cas.pm.web.flow.VerifyPasswordResetRequestAction;
import org.apereo.cas.pm.web.flow.VerifySecurityQuestionsAction;
import org.apereo.cas.util.cipher.NoOpCipherExecutor;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

@Configuration(value="passwordManagementConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordManagementConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="loginFlowExecutor")
    private FlowExecutor loginFlowExecutor;

    @RefreshScope
    @Bean
    public HandlerAdapter passwordResetHandlerAdapter() {
        FlowHandlerAdapter handler = new FlowHandlerAdapter(){

            public boolean supports(Object handler) {
                return super.supports(handler) && ((FlowHandler)handler).getFlowId().equals("pswdreset");
            }
        };
        handler.setFlowExecutor(this.loginFlowExecutor);
        return handler;
    }

    @RefreshScope
    @Bean
    public Action initPasswordChangeAction() {
        return new InitPasswordChangeAction();
    }

    @Autowired
    @RefreshScope
    @Bean
    public Action initPasswordResetAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
        return new InitPasswordResetAction(passwordManagementService);
    }

    @RefreshScope
    @Bean
    public Action passwordChangeAction() {
        return new PasswordChangeAction(this.passwordChangeService());
    }

    @RefreshScope
    @Bean
    public CipherExecutor<String, String> passwordManagementCipherExecutor() {
        if (this.casProperties.getAuthn().getPm().isEnabled()) {
            return new PasswordResetTokenCipherExecutor(this.casProperties.getAuthn().getPm().getReset().getSecurity().getEncryptionKey(), this.casProperties.getAuthn().getPm().getReset().getSecurity().getSigningKey());
        }
        return new NoOpCipherExecutor();
    }

    @ConditionalOnMissingBean(name={"passwordChangeService"})
    @RefreshScope
    @Bean
    public PasswordManagementService passwordChangeService() {
        if (this.casProperties.getAuthn().getPm().isEnabled() && StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getPm().getLdap().getLdapUrl()) && StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getPm().getLdap().getBaseDn()) && StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getPm().getLdap().getUserFilter())) {
            return new LdapPasswordManagementService(this.passwordManagementCipherExecutor());
        }
        if (this.casProperties.getAuthn().getPm().isEnabled()) {
            LOGGER.warn("No backend is configured to handle the account update operations. Verify your settings");
        }
        return new PasswordManagementService(){};
    }

    @Autowired
    @Bean
    public Action sendPasswordResetInstructionsAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
        return new SendPasswordResetInstructionsAction(passwordManagementService);
    }

    @Bean
    public Action verifyPasswordResetRequestAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
        return new VerifyPasswordResetRequestAction(passwordManagementService);
    }

    @Bean
    public Action verifySecurityQuestionsAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
        return new VerifySecurityQuestionsAction(passwordManagementService);
    }

    @ConditionalOnMissingBean(name={"passwordManagementWebflowConfigurer"})
    @RefreshScope
    @Bean
    public CasWebflowConfigurer passwordManagementWebflowConfigurer() {
        PasswordManagementWebflowConfigurer w = new PasswordManagementWebflowConfigurer();
        w.setLoginFlowDefinitionRegistry(this.loginFlowDefinitionRegistry);
        w.setFlowBuilderServices(this.flowBuilderServices);
        return w;
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"passwordValidator"})
    @Bean
    public PasswordValidator passwordValidator() {
        return new PasswordValidator();
    }
}

