/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;

public class OAuthRefreshTokenExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -7144233906843566234L;
    private long timeToKillInMilliSeconds;

    public OAuthRefreshTokenExpirationPolicy() {
    }

    public OAuthRefreshTokenExpirationPolicy(long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
    }

    public boolean isExpired(TicketState ticketState) {
        return ticketState == null || ticketState.getCreationTime().plus(this.timeToKillInMilliSeconds, ChronoUnit.MILLIS).isBefore(ZonedDateTime.now(ZoneOffset.UTC));
    }

    public Long getTimeToLive() {
        return this.timeToKillInMilliSeconds;
    }

    public Long getTimeToIdle() {
        return 0L;
    }
}

