/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenImpl;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;

public class DefaultRefreshTokenFactory
implements RefreshTokenFactory {
    protected UniqueTicketIdGenerator refreshTokenIdGenerator = new DefaultUniqueTicketIdGenerator();
    protected ExpirationPolicy expirationPolicy;

    @Override
    public RefreshToken create(Service service, Authentication authentication) {
        String codeId = this.refreshTokenIdGenerator.getNewTicketId("RT");
        return new RefreshTokenImpl(codeId, service, authentication, this.expirationPolicy);
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }

    public UniqueTicketIdGenerator getRefreshTokenIdGenerator() {
        return this.refreshTokenIdGenerator;
    }

    public void setRefreshTokenIdGenerator(UniqueTicketIdGenerator refreshTokenIdGenerator) {
        this.refreshTokenIdGenerator = refreshTokenIdGenerator;
    }

    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }
}

