/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.code.OAuthCodeImpl;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;

public class DefaultOAuthCodeFactory
implements OAuthCodeFactory {
    protected UniqueTicketIdGenerator oAuthCodeIdGenerator = new DefaultUniqueTicketIdGenerator();
    protected ExpirationPolicy expirationPolicy;

    @Override
    public OAuthCode create(Service service, Authentication authentication) {
        String codeId = this.oAuthCodeIdGenerator.getNewTicketId("OC");
        return new OAuthCodeImpl(codeId, service, authentication, this.expirationPolicy);
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }

    public UniqueTicketIdGenerator getoAuthCodeIdGenerator() {
        return this.oAuthCodeIdGenerator;
    }

    public void setoAuthCodeIdGenerator(UniqueTicketIdGenerator oAuthCodeIdGenerator) {
        this.oAuthCodeIdGenerator = oAuthCodeIdGenerator;
    }

    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }
}

