/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apereo.cas.support.oauth.web.BaseOAuthWrapperController;
import org.apereo.cas.support.oauth.web.OAuth20CallbackAuthorizeViewResolver;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.springframework.web.CallbackController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20CallbackAuthorizeController
extends BaseOAuthWrapperController {
    private Config config;
    private CallbackController callbackController;
    private OAuth20CallbackAuthorizeViewResolver oAuth20CallbackAuthorizeViewResolver;

    @PostConstruct
    private void postConstruct() {
        this.callbackController.setConfig(this.config);
    }

    @RequestMapping(path={"/oauth2.0/callbackAuthorize"})
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.callbackController.callback(request, response);
        String url = StringUtils.remove((String)response.getHeader("Location"), (String)"redirect:");
        J2EContext ctx = new J2EContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)ctx);
        return this.oAuth20CallbackAuthorizeViewResolver.resolve(ctx, manager, url);
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setCallbackController(CallbackController callbackController) {
        this.callbackController = callbackController;
    }

    public void setAuth20CallbackAuthorizeViewResolver(OAuth20CallbackAuthorizeViewResolver oAuth20CallbackAuthorizeViewResolver) {
        this.oAuth20CallbackAuthorizeViewResolver = oAuth20CallbackAuthorizeViewResolver;
    }
}

