/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuthUtils;
import org.apereo.cas.support.oauth.web.AccessTokenResponseGenerator;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;

public class OAuth20AccessTokenResponseGenerator
implements AccessTokenResponseGenerator {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ResourceLoader resourceLoader;
    @Autowired
    protected CasConfigurationProperties casProperties;

    @Override
    public void generate(HttpServletRequest request, HttpServletResponse response, OAuthRegisteredService registeredService, Service service, AccessToken accessTokenId, RefreshToken refreshTokenId, long timeout) {
        block15: {
            if (registeredService.isJsonFormat().booleanValue()) {
                response.setContentType("application/json");
                JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());
                try (JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)response.getWriter());){
                    jsonGenerator.writeStartObject();
                    this.generateJsonInternal(request, response, jsonGenerator, accessTokenId, refreshTokenId, timeout, service, registeredService);
                    jsonGenerator.writeEndObject();
                    break block15;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            this.generateTextInternal(request, response, accessTokenId, refreshTokenId, timeout);
        }
    }

    protected void generateTextInternal(HttpServletRequest request, HttpServletResponse response, AccessToken accessTokenId, RefreshToken refreshTokenId, long timeout) {
        StringBuilder builder = new StringBuilder(String.format("%s=%s&%s=%s", "access_token", accessTokenId.getId(), "expires_in", timeout));
        if (refreshTokenId != null) {
            builder.append('&').append("refresh_token").append('=').append(refreshTokenId.getId());
        }
        OAuthUtils.writeText(response, builder.toString(), 200);
    }

    protected void generateJsonInternal(HttpServletRequest request, HttpServletResponse response, JsonGenerator jsonGenerator, AccessToken accessTokenId, RefreshToken refreshTokenId, long timeout, Service service, OAuthRegisteredService registeredService) throws Exception {
        jsonGenerator.writeStringField("access_token", accessTokenId.getId());
        jsonGenerator.writeStringField("token_type", "bearer");
        jsonGenerator.writeNumberField("expires_in", timeout);
        if (refreshTokenId != null) {
            jsonGenerator.writeStringField("refresh_token", refreshTokenId.getId());
        }
    }
}

