/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.BasicCredentialMetaData;
import org.apereo.cas.authentication.BasicIdentifiableCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.DefaultHandlerResult;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthWebApplicationService;
import org.apereo.cas.support.oauth.validator.OAuthValidator;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public abstract class BaseOAuthWrapperController {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ServicesManager servicesManager;
    protected TicketRegistry ticketRegistry;
    protected OAuthValidator validator;
    private AccessTokenFactory accessTokenFactory;
    private PrincipalFactory principalFactory;

    protected AccessToken generateAccessToken(Service service, Authentication authentication, J2EContext context) {
        AccessToken accessToken = this.accessTokenFactory.create(service, authentication);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        return accessToken;
    }

    protected OAuthWebApplicationService createService(RegisteredService registeredService) {
        return new OAuthWebApplicationService(registeredService);
    }

    protected Authentication createAuthentication(UserProfile profile, RegisteredService service, J2EContext context) {
        Principal principal = this.principalFactory.createPrincipal(profile.getId(), profile.getAttributes());
        Map newAttributes = service.getAttributeReleasePolicy().getAttributes(principal);
        Principal newPrincipal = this.principalFactory.createPrincipal(profile.getId(), newAttributes);
        String authenticator = profile.getClass().getCanonicalName();
        BasicCredentialMetaData metadata = new BasicCredentialMetaData((Credential)new BasicIdentifiableCredential(profile.getId()));
        DefaultHandlerResult handlerResult = new DefaultHandlerResult(authenticator, (CredentialMetaData)metadata, newPrincipal, new ArrayList());
        String state = (String)StringUtils.defaultIfBlank((CharSequence)context.getRequestParameter("state"), (CharSequence)"");
        String nonce = (String)StringUtils.defaultIfBlank((CharSequence)context.getRequestParameter("nonce"), (CharSequence)"");
        AuthenticationBuilder bldr = DefaultAuthenticationBuilder.newInstance().addAttribute("permissions", (Object)profile.getPermissions()).addAttribute("roles", (Object)profile.getRoles()).addAttribute("state", (Object)state).addAttribute("nonce", (Object)nonce).addCredential((CredentialMetaData)metadata).setPrincipal(newPrincipal).setAuthenticationDate(ZonedDateTime.now()).addSuccess(profile.getClass().getCanonicalName(), (HandlerResult)handlerResult);
        profile.getAttributes().forEach((k, v) -> {
            if (!newPrincipal.getAttributes().containsKey(k)) {
                bldr.addAttribute(k, v);
            }
        });
        return bldr.build();
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    public AccessTokenFactory getAccessTokenFactory() {
        return this.accessTokenFactory;
    }

    public void setAccessTokenFactory(AccessTokenFactory accessTokenFactory) {
        this.accessTokenFactory = accessTokenFactory;
    }

    public OAuthValidator getValidator() {
        return this.validator;
    }

    public void setValidator(OAuthValidator validator) {
        this.validator = validator;
    }

    public PrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }
}

