/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthWebApplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthValidator {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean checkParameterExist(HttpServletRequest request, String name) {
        String parameter = request.getParameter(name);
        this.logger.debug("{}: {}", (Object)name, (Object)parameter);
        if (StringUtils.isBlank((CharSequence)parameter)) {
            this.logger.error("Missing: {}", (Object)name);
            return false;
        }
        return true;
    }

    public boolean checkServiceValid(RegisteredService registeredService) {
        OAuthWebApplicationService service = new OAuthWebApplicationService(registeredService);
        this.logger.debug("Check registered service: {}", (Object)registeredService);
        try {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            return true;
        }
        catch (UnauthorizedServiceException e) {
            return false;
        }
    }

    public boolean checkCallbackValid(RegisteredService registeredService, String redirectUri) {
        String registeredServiceId = registeredService.getServiceId();
        this.logger.debug("Found: {} vs redirectUri: {}", (Object)registeredService, (Object)redirectUri);
        if (!redirectUri.matches(registeredServiceId)) {
            this.logger.error("Unsupported {}: {} for registeredServiceId: {}", new Object[]{"redirect_uri", redirectUri, registeredServiceId});
            return false;
        }
        return true;
    }

    public boolean checkClientSecret(OAuthRegisteredService registeredService, String clientSecret) {
        this.logger.debug("Found: {} in secret check", (Object)registeredService);
        if (!StringUtils.equals((CharSequence)registeredService.getClientSecret(), (CharSequence)clientSecret)) {
            this.logger.error("Wrong client secret for service: {}", (Object)registeredService);
            return false;
        }
        return true;
    }
}

