/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAccessTokenExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -8383186650682727360L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthAccessTokenExpirationPolicy.class);
    private long maxTimeToLiveInSeconds;
    private long timeToKillInSeconds;

    public OAuthAccessTokenExpirationPolicy() {
    }

    public OAuthAccessTokenExpirationPolicy(long maxTimeToLive, long timeToKill) {
        this.maxTimeToLiveInSeconds = maxTimeToLive;
        this.timeToKillInSeconds = timeToKill;
    }

    public boolean isExpired(TicketState ticketState) {
        ZonedDateTime creationTime;
        ZonedDateTime expirationTime;
        ZonedDateTime currentSystemTime = ZonedDateTime.now(ZoneOffset.UTC);
        if (currentSystemTime.isAfter(expirationTime = (creationTime = ticketState.getCreationTime()).plus(this.maxTimeToLiveInSeconds, ChronoUnit.SECONDS))) {
            LOGGER.debug("Access token is expired because the time since creation is greater than maxTimeToLiveInSeconds");
            return true;
        }
        expirationTime = creationTime.plus(this.timeToKillInSeconds, ChronoUnit.SECONDS);
        if (ticketState.getLastTimeUsed().isAfter(expirationTime)) {
            LOGGER.debug("Access token is expired because the time since last use is greater than timeToKillInMilliseconds");
            return true;
        }
        return false;
    }

    public Long getTimeToLive() {
        return this.maxTimeToLiveInSeconds;
    }

    public Long getTimeToIdle() {
        return this.timeToKillInSeconds;
    }
}

