/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public final class OAuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthUtils.class);

    private OAuthUtils() {
    }

    public static ModelAndView writeTextError(HttpServletResponse response, String error) {
        return OAuthUtils.writeText(response, "error=" + error, 400);
    }

    public static ModelAndView writeText(HttpServletResponse response, String text, int status) {
        try (PrintWriter printWriter = response.getWriter();){
            response.setStatus(status);
            printWriter.print(text);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write to response", (Throwable)e);
        }
        return null;
    }

    public static ModelAndView redirectTo(String url) {
        return new ModelAndView((View)new RedirectView(url));
    }

    public static OAuthRegisteredService getRegisteredOAuthService(ServicesManager servicesManager, String clientId) {
        for (RegisteredService aService : servicesManager.getAllServices()) {
            OAuthRegisteredService service;
            if (!(aService instanceof OAuthRegisteredService) || !(service = (OAuthRegisteredService)aService).getClientId().equals(clientId)) continue;
            return service;
        }
        return null;
    }

    public static String jsonify(Map map) {
        try {
            String value = new ObjectMapper().writer().withDefaultPrettyPrinter().writeValueAsString((Object)map);
            return value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

